/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.transmitter;

import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tier.CableTier;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;

public class BlockUniversalCable
extends BlockSmallTransmitter
implements ITypeBlock,
IHasTileEntity<TileEntityUniversalCable> {
    private final CableTier tier;

    public BlockUniversalCable(CableTier tier) {
        this.tier = tier;
    }

    @Override
    public BlockType getType() {
        return AttributeTier.getPassthroughType(this.tier);
    }

    @Override
    public TileEntityTypeRegistryObject<TileEntityUniversalCable> getTileType() {
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case CableTier.ADVANCED -> MekanismTileEntityTypes.ADVANCED_UNIVERSAL_CABLE;
            case CableTier.ELITE -> MekanismTileEntityTypes.ELITE_UNIVERSAL_CABLE;
            case CableTier.ULTIMATE -> MekanismTileEntityTypes.ULTIMATE_UNIVERSAL_CABLE;
            case CableTier.BASIC -> MekanismTileEntityTypes.BASIC_UNIVERSAL_CABLE;
        };
    }
}

