/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import java.util.Objects;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.miner.MinerFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MinerMaterialFilter
extends MinerFilter<MinerMaterialFilter>
implements IMaterialFilter<MinerMaterialFilter> {
    private ItemStack materialItem = ItemStack.f_41583_;

    public MinerMaterialFilter(ItemStack item) {
        this.materialItem = item;
    }

    public MinerMaterialFilter() {
    }

    public MinerMaterialFilter(MinerMaterialFilter filter) {
        super(filter);
        this.materialItem = filter.materialItem.m_41777_();
    }

    @Override
    public boolean canFilter(BlockState state) {
        return state.m_60767_() == this.getMaterial();
    }

    @Override
    public boolean hasBlacklistedElement() {
        return !this.materialItem.m_41619_() && this.materialItem.m_41720_() instanceof BlockItem && TagCache.materialHasMinerBlacklisted(this.materialItem);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        this.materialItem.m_41739_(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        this.materialItem = ItemStack.m_41712_((CompoundTag)nbtTags);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.m_130055_(this.materialItem);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.materialItem = dataStream.m_130267_();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.materialItem.m_41720_());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        MinerMaterialFilter other = (MinerMaterialFilter)o;
        return this.materialItem.m_41656_(other.materialItem);
    }

    @Override
    public MinerMaterialFilter clone() {
        return new MinerMaterialFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_MATERIAL_FILTER;
    }

    @Override
    @NotNull
    public ItemStack getMaterialItem() {
        return this.materialItem;
    }

    @Override
    public void setMaterialItem(@NotNull ItemStack stack) {
        this.materialItem = stack;
    }
}

