/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import com.blamejared.recipestages.RecipeStagesUtil;
import com.blamejared.recipestages.recipes.IStagedRecipe;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowOutputInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QIOCraftingWindow
implements IContentsListener {
    private static final SelectedWindowData[] WINDOWS = new SelectedWindowData[3];
    private final CraftingWindowInventorySlot[] inputSlots = new CraftingWindowInventorySlot[9];
    private final ReplacementHelper replacementHelper = new ReplacementHelper();
    private final RemainderHelper remainderHelper = new RemainderHelper();
    private final CraftingWindowOutputInventorySlot outputSlot;
    private final QIOCraftingInventory craftingInventory;
    private final IQIOCraftingWindowHolder holder;
    private final SelectedWindowData windowData;
    private final byte windowIndex;
    @Nullable
    private CraftingRecipe lastRecipe;
    private boolean isCrafting;
    private boolean changedWhileCrafting;

    public QIOCraftingWindow(IQIOCraftingWindowHolder holder, byte windowIndex) {
        this.windowIndex = windowIndex;
        this.holder = holder;
        this.windowData = WINDOWS[windowIndex];
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            this.inputSlots[slotIndex] = CraftingWindowInventorySlot.input(this, this.holder);
        }
        this.outputSlot = CraftingWindowOutputInventorySlot.create(this);
        this.craftingInventory = new QIOCraftingInventory();
    }

    public SelectedWindowData getWindowData() {
        return this.windowData;
    }

    public byte getWindowIndex() {
        return this.windowIndex;
    }

    public CraftingWindowInventorySlot getInputSlot(int slot) {
        if (slot < 0 || slot >= 9) {
            throw new IllegalArgumentException("Input slot out of range");
        }
        return this.inputSlots[slot];
    }

    public CraftingWindowOutputInventorySlot getOutputSlot() {
        return this.outputSlot;
    }

    public boolean isOutput(@NotNull ItemStack stack) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.outputSlot.getStack(), (ItemStack)stack);
    }

    @Override
    public void onContentsChanged() {
        if (this.isCrafting) {
            this.changedWhileCrafting = true;
        } else {
            Level world = this.holder.getHolderWorld();
            if (world != null && !world.f_46443_) {
                this.updateOutputSlot(world);
            }
        }
    }

    public void invalidateRecipe() {
        Level world;
        this.lastRecipe = null;
        if (!this.outputSlot.isEmpty()) {
            this.outputSlot.setEmpty();
        }
        if ((world = this.holder.getHolderWorld()) != null && !world.f_46443_) {
            this.updateOutputSlot(world);
        }
    }

    private void updateOutputSlot(@NotNull Level world) {
        if (world.m_7654_() != null) {
            if (this.craftingInventory.m_7983_()) {
                if (!this.outputSlot.isEmpty()) {
                    this.outputSlot.setEmpty();
                }
            } else if (this.lastRecipe != null && this.lastRecipe.m_5818_((Container)this.craftingInventory, world)) {
                this.outputSlot.setStack(this.assembleRecipe(this.lastRecipe));
            } else {
                CraftingRecipe recipe = MekanismRecipeType.getRecipeFor(RecipeType.f_44107_, this.craftingInventory, world).orElse(null);
                if (recipe != this.lastRecipe) {
                    if (recipe == null) {
                        if (!this.outputSlot.isEmpty()) {
                            this.outputSlot.setEmpty();
                        }
                    } else {
                        this.lastRecipe = recipe;
                        this.outputSlot.setStack(this.assembleRecipe(this.lastRecipe));
                    }
                }
            }
        }
    }

    private ItemStack assembleRecipe(CraftingRecipe recipe) {
        if (Mekanism.hooks.RecipeStagesLoaded && recipe instanceof IStagedRecipe) {
            IStagedRecipe stagedRecipe = (IStagedRecipe)recipe;
            return stagedRecipe.forceAssemble((CraftingContainer)this.craftingInventory);
        }
        return recipe.m_5874_((Container)this.craftingInventory);
    }

    public boolean canViewRecipe(@NotNull ServerPlayer player) {
        if (this.lastRecipe == null) {
            return false;
        }
        if (Mekanism.hooks.RecipeStagesLoaded && !RecipeStagesUtil.hasStageForRecipe((Recipe)this.lastRecipe, (Player)player)) {
            return false;
        }
        return this.lastRecipe.m_5598_() || !player.f_19853_.m_46469_().m_46207_(GameRules.f_46151_) || player.m_8952_().m_12709_((Recipe)this.lastRecipe);
    }

    @Contract(value="null, _ -> false")
    private boolean validateAndUnlockRecipe(@Nullable Level world, @NotNull Player player) {
        if (world == null || this.lastRecipe == null || !this.lastRecipe.m_5818_((Container)this.craftingInventory, world)) {
            return false;
        }
        if (this.lastRecipe != null && !this.lastRecipe.m_5598_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (world.m_46469_().m_46207_(GameRules.f_46151_) && !serverPlayer.m_8952_().m_12709_((Recipe)this.lastRecipe)) {
                    return false;
                }
            }
            player.m_7281_(Collections.singleton(this.lastRecipe));
        }
        return true;
    }

    private void craftingStarted(@NotNull Player player) {
        this.isCrafting = true;
        ForgeHooks.setCraftingPlayer((Player)player);
    }

    private void craftingFinished(@NotNull Level world) {
        ForgeHooks.setCraftingPlayer(null);
        this.isCrafting = false;
        if (this.changedWhileCrafting) {
            this.changedWhileCrafting = false;
            this.updateOutputSlot(world);
        }
    }

    private int calculateMaxCraftAmount(@NotNull ItemStack stack, @Nullable QIOFrequency frequency) {
        CraftingWindowInventorySlot inputSlot;
        int count;
        int outputSize = stack.m_41613_();
        int inputSize = 64;
        CraftingWindowInventorySlot[] craftingWindowInventorySlotArray = this.inputSlots;
        int n = craftingWindowInventorySlotArray.length;
        for (int i = 0; i < n && ((count = (inputSlot = craftingWindowInventorySlotArray[i]).getCount()) <= 0 || count >= inputSize || (inputSize = count) != 1); ++i) {
        }
        if (inputSize > 1) {
            return inputSize * outputSize;
        }
        if (frequency == null) {
            return outputSize;
        }
        int maxToCraft = stack.m_41741_();
        if (outputSize < maxToCraft) {
            maxToCraft -= maxToCraft % outputSize;
        }
        return maxToCraft;
    }

    private void useInput(IInventorySlot inputSlot) {
        MekanismUtils.logMismatchedStackSize(inputSlot.shrinkStack(1, Action.EXECUTE), 1L);
    }

    public void emptyTo(boolean toPlayerInv, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
        if (toPlayerInv) {
            this.emptyTo(toTransfer -> {
                ItemStack remainder = MekanismContainer.insertItem(hotBarSlots, toTransfer, true, this.windowData);
                remainder = MekanismContainer.insertItem(mainInventorySlots, remainder, true, this.windowData);
                remainder = MekanismContainer.insertItem(hotBarSlots, remainder, false, this.windowData);
                return MekanismContainer.insertItem(mainInventorySlots, remainder, false, this.windowData);
            });
        } else {
            QIOFrequency frequency = this.holder.getFrequency();
            if (frequency != null) {
                this.emptyTo(frequency::addItem);
            }
        }
    }

    private void emptyTo(UnaryOperator<ItemStack> inserter) {
        for (CraftingWindowInventorySlot inputSlot : this.inputSlots) {
            ItemStack toTransfer;
            if (inputSlot.isEmpty() || (toTransfer = inputSlot.extractItem(inputSlot.getCount(), Action.SIMULATE, AutomationType.INTERNAL)).m_41619_()) continue;
            ItemStack remainder = (ItemStack)inserter.apply(toTransfer);
            inputSlot.extractItem(toTransfer.m_41613_() - remainder.m_41613_(), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public void performCraft(@NotNull Player player, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
        int crafted;
        if (this.lastRecipe == null || this.outputSlot.isEmpty()) {
            return;
        }
        Level world = this.holder.getHolderWorld();
        if (!this.validateAndUnlockRecipe(world, player)) {
            return;
        }
        QIOFrequency frequency = this.holder.getFrequency();
        this.craftingStarted(player);
        ItemStack result = this.outputSlot.getStack().m_41777_();
        Item resultItem = result.m_41720_();
        resultItem.m_7836_(result, world, player);
        Stat itemCraftedStat = Stats.f_12981_.m_12902_((Object)resultItem);
        int maxToCraft = this.calculateMaxCraftAmount(result, frequency);
        int amountPerCraft = result.m_41613_();
        this.remainderHelper.reset();
        this.replacementHelper.reset();
        boolean recheckOutput = false;
        LastInsertTarget lastInsertTarget = new LastInsertTarget();
        NonNullList remaining = this.lastRecipe.m_7457_((Container)this.craftingInventory);
        for (crafted = 0; crafted < maxToCraft; crafted += amountPerCraft) {
            if (recheckOutput && this.changedWhileCrafting) {
                ItemStack updatedOutput;
                recheckOutput = false;
                this.changedWhileCrafting = false;
                CraftingRecipe oldRecipe = this.lastRecipe;
                this.updateOutputSlot(world);
                if (oldRecipe != this.lastRecipe || (updatedOutput = this.outputSlot.getStack()).m_41619_() || updatedOutput.m_41720_() != resultItem) break;
                ItemStack potentialUpdatedOutput = updatedOutput.m_41777_();
                resultItem.m_7836_(potentialUpdatedOutput, world, player);
                if (!ItemStack.m_41728_((ItemStack)result, (ItemStack)potentialUpdatedOutput)) break;
                remaining = this.lastRecipe.m_7457_((Container)this.craftingInventory);
            }
            ItemStack simulatedRemainder = MekanismContainer.insertItemCheckAll(hotBarSlots, result, this.windowData, Action.SIMULATE);
            if (!(simulatedRemainder = MekanismContainer.insertItemCheckAll(mainInventorySlots, simulatedRemainder, this.windowData, Action.SIMULATE)).m_41619_()) break;
            ItemStack toInsert = lastInsertTarget.tryInserting(hotBarSlots, mainInventorySlots, this.windowData, result);
            if (!toInsert.m_41619_()) {
                player.m_36176_(toInsert, false);
            }
            boolean stopCrafting = false;
            for (int index = 0; index < remaining.size(); ++index) {
                ItemStack remainder = (ItemStack)remaining.get(index);
                CraftingWindowInventorySlot inputSlot = this.inputSlots[index];
                if (inputSlot.getCount() > 1) {
                    this.useInput(inputSlot);
                } else if (inputSlot.getCount() == 1) {
                    if (frequency == null || this.remainderHelper.isStackStillValid(world, remainder, index)) {
                        this.useInput(inputSlot);
                        recheckOutput = true;
                    } else {
                        ItemStack current = inputSlot.getStack();
                        ItemStack removed = frequency.removeItem(current, 1);
                        if (removed.m_41619_()) {
                            this.useInput(inputSlot);
                            this.replacementHelper.findEquivalentItem(world, frequency, inputSlot, index, current);
                            stopCrafting = true;
                        }
                    }
                } else if (!remainder.m_41619_()) {
                    recheckOutput = true;
                }
                this.addRemainingItem(player, frequency, inputSlot, remainder, true);
            }
            if (!stopCrafting) continue;
            crafted += amountPerCraft;
            break;
        }
        if (crafted > 0) {
            player.m_6278_(itemCraftedStat, crafted);
        }
        this.craftingFinished(world);
    }

    @NotNull
    public ItemStack performCraft(@NotNull Player player, @NotNull ItemStack result, int amountCrafted) {
        if (amountCrafted == 0 || this.lastRecipe == null || result.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Level world = this.holder.getHolderWorld();
        if (!this.validateAndUnlockRecipe(world, player)) {
            return ItemStack.f_41583_;
        }
        QIOFrequency frequency = this.holder.getFrequency();
        this.craftingStarted(player);
        result.m_41678_(world, player, amountCrafted);
        NonNullList remaining = this.lastRecipe.m_7457_((Container)this.craftingInventory);
        this.remainderHelper.reset();
        this.replacementHelper.reset();
        for (int index = 0; index < remaining.size(); ++index) {
            ItemStack remainder = (ItemStack)remaining.get(index);
            CraftingWindowInventorySlot inputSlot = this.inputSlots[index];
            if (inputSlot.getCount() > 1) {
                this.useInput(inputSlot);
            } else if (inputSlot.getCount() == 1) {
                if (frequency == null || this.remainderHelper.isStackStillValid(world, remainder, index)) {
                    this.useInput(inputSlot);
                } else {
                    ItemStack current = inputSlot.getStack();
                    ItemStack removed = frequency.removeItem(current, 1);
                    if (removed.m_41619_()) {
                        this.useInput(inputSlot);
                        this.replacementHelper.findEquivalentItem(world, frequency, inputSlot, index, current);
                    }
                }
            }
            this.addRemainingItem(player, frequency, inputSlot, remainder, false);
        }
        this.craftingFinished(world);
        return result;
    }

    private void addRemainingItem(Player player, @Nullable QIOFrequency frequency, IInventorySlot slot, @NotNull ItemStack remainder, boolean copyIfNeeded) {
        int toInsert = remainder.m_41613_();
        if (!(remainder = slot.insertItem(remainder, Action.EXECUTE, AutomationType.INTERNAL)).m_41619_()) {
            if (copyIfNeeded && toInsert == remainder.m_41613_()) {
                remainder = remainder.m_41777_();
            }
            if (!player.m_150109_().m_36054_(remainder)) {
                if (frequency != null && (remainder = frequency.addItem(remainder)).m_41619_()) {
                    return;
                }
                player.m_36176_(remainder, false);
            }
        }
    }

    static {
        for (byte tableIndex = 0; tableIndex < WINDOWS.length; tableIndex = (byte)(tableIndex + 1)) {
            QIOCraftingWindow.WINDOWS[tableIndex] = new SelectedWindowData(SelectedWindowData.WindowType.CRAFTING, tableIndex);
        }
    }

    private class ReplacementHelper {
        private final Int2ObjectMap<Ingredient> slotIngredients;
        private boolean mapped;
        private boolean invalid;

        private ReplacementHelper() {
            this.slotIngredients = new Int2ObjectArrayMap(QIOCraftingWindow.this.inputSlots.length);
        }

        public void reset() {
            if (this.mapped) {
                this.mapped = false;
                this.invalid = false;
                this.slotIngredients.clear();
            }
        }

        public void findEquivalentItem(Level world, @NotNull QIOFrequency frequency, CraftingWindowInventorySlot slot, int index, ItemStack used) {
            this.mapRecipe(index, used);
            if (this.invalid) {
                return;
            }
            Ingredient usedIngredient = (Ingredient)this.slotIngredients.getOrDefault(index, (Object)Ingredient.f_43901_);
            if (usedIngredient.test(used)) {
                for (ItemStack item : usedIngredient.m_43908_()) {
                    if (item.m_41619_()) continue;
                    if (!usedIngredient.isVanilla() && this.testEquivalentItem(world, frequency, slot, index, usedIngredient, HashedItem.raw(item))) {
                        return;
                    }
                    for (HashedItem type : frequency.getTypesForItem(item.m_41720_())) {
                        if (!this.testEquivalentItem(world, frequency, slot, index, usedIngredient, type)) continue;
                        return;
                    }
                }
            }
        }

        private boolean testEquivalentItem(Level world, @NotNull QIOFrequency frequency, CraftingWindowInventorySlot slot, int index, Ingredient usedIngredient, HashedItem replacementType) {
            if (!frequency.isStoring(replacementType) || !usedIngredient.test(replacementType.getInternalStack())) {
                return false;
            }
            ItemStack replacement = replacementType.createStack(1);
            ItemStack old = QIOCraftingWindow.this.remainderHelper.dummy.m_8020_(index);
            if (QIOCraftingWindow.this.remainderHelper.isStackStillValid(world, replacement, index)) {
                ItemStack removed;
                if (slot.insertItem(replacement, Action.SIMULATE, AutomationType.INTERNAL).m_41619_() && !(removed = frequency.removeByType(replacementType, 1)).m_41619_()) {
                    ItemStack stack = slot.insertItem(removed, Action.EXECUTE, AutomationType.INTERNAL);
                    if (!stack.m_41619_()) {
                        Mekanism.logger.error("Failed to insert item ({} with NBT: {}) into crafting window: {}.", new Object[]{removed.m_41720_(), removed.m_41783_(), QIOCraftingWindow.this.windowIndex});
                    }
                    return true;
                }
                QIOCraftingWindow.this.remainderHelper.dummy.m_6836_(index, old);
            }
            return false;
        }

        private void mapRecipe(int index, ItemStack used) {
            if (!this.mapped) {
                this.mapped = true;
                if (QIOCraftingWindow.this.lastRecipe == null || QIOCraftingWindow.this.lastRecipe.m_5598_()) {
                    this.invalid = true;
                    return;
                }
                NonNullList ingredients = QIOCraftingWindow.this.lastRecipe.m_7527_();
                if (ingredients.isEmpty()) {
                    this.invalid = true;
                    return;
                }
                QIOCraftingWindow.this.remainderHelper.updateInputsWithReplacement(index, used);
                IntFunction<ItemStack> itemGetter = i -> {
                    if (i == index) {
                        return used;
                    }
                    if (i >= 0 && i < QIOCraftingWindow.this.inputSlots.length) {
                        return QIOCraftingWindow.this.inputSlots[i].getStack();
                    }
                    return ItemStack.f_41583_;
                };
                CraftingRecipe craftingRecipe = QIOCraftingWindow.this.lastRecipe;
                if (craftingRecipe instanceof IShapedRecipe) {
                    IShapedRecipe shapedRecipe = (IShapedRecipe)craftingRecipe;
                    this.mapShapedRecipe(shapedRecipe, (NonNullList<Ingredient>)ingredients, itemGetter);
                } else {
                    this.mapShapelessRecipe((NonNullList<Ingredient>)ingredients, itemGetter);
                }
            }
        }

        private void mapShapedRecipe(IShapedRecipe<?> shapedRecipe, NonNullList<Ingredient> ingredients, IntFunction<ItemStack> itemGetter) {
            int recipeWidth = shapedRecipe.getRecipeWidth();
            int recipeHeight = shapedRecipe.getRecipeHeight();
            for (int columnStart = 0; columnStart <= 3 - recipeWidth; ++columnStart) {
                for (int rowStart = 0; rowStart <= 3 - recipeHeight; ++rowStart) {
                    if (!this.mapShapedRecipe(ingredients, columnStart, rowStart, recipeWidth, recipeHeight, true, itemGetter) && !this.mapShapedRecipe(ingredients, columnStart, rowStart, recipeWidth, recipeHeight, false, itemGetter)) continue;
                    return;
                }
            }
            this.invalid = true;
        }

        private boolean mapShapedRecipe(NonNullList<Ingredient> ingredients, int columnStart, int rowStart, int recipeWidth, int recipeHeight, boolean mirrored, IntFunction<ItemStack> itemGetter) {
            for (int actualColumn = 0; actualColumn < 3; ++actualColumn) {
                for (int actualRow = 0; actualRow < 3; ++actualRow) {
                    int index;
                    int column = actualColumn - columnStart;
                    int row = actualRow - rowStart;
                    Ingredient ingredient = Ingredient.f_43901_;
                    if (column >= 0 && row >= 0 && column < recipeWidth && row < recipeHeight) {
                        ingredient = mirrored ? (Ingredient)ingredients.get(recipeWidth - column - 1 + row * recipeWidth) : (Ingredient)ingredients.get(column + row * recipeWidth);
                    }
                    if (!ingredient.test(itemGetter.apply(index = actualColumn + actualRow * 3))) {
                        this.slotIngredients.clear();
                        return false;
                    }
                    this.slotIngredients.put(index, (Object)ingredient);
                }
            }
            return true;
        }

        private void mapShapelessRecipe(NonNullList<Ingredient> ingredients, IntFunction<ItemStack> itemGetter) {
            Int2IntArrayMap actualLookup = new Int2IntArrayMap(QIOCraftingWindow.this.inputSlots.length);
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(QIOCraftingWindow.this.inputSlots.length);
            for (int index = 0; index < QIOCraftingWindow.this.inputSlots.length; ++index) {
                ItemStack stack = itemGetter.apply(index);
                if (stack.m_41619_()) continue;
                actualLookup.put(inputs.size(), index);
                inputs.add(stack);
            }
            int[] matches = RecipeMatcher.findMatches(inputs, ingredients);
            if (matches != null) {
                for (int ingredientIndex = 0; ingredientIndex < matches.length; ++ingredientIndex) {
                    int actualSlot = actualLookup.getOrDefault(matches[ingredientIndex], -1);
                    if (actualSlot == -1) {
                        this.invalid = true;
                        return;
                    }
                    this.slotIngredients.put(actualSlot, (Object)((Ingredient)ingredients.get(ingredientIndex)));
                }
            } else {
                this.invalid = true;
            }
        }
    }

    private class RemainderHelper {
        private final CraftingContainer dummy = MekanismUtils.getDummyCraftingInv();
        private boolean updated;

        private RemainderHelper() {
        }

        public void reset() {
            if (this.updated) {
                this.updated = false;
                this.dummy.m_6211_();
            }
        }

        private void updateInputs(@NotNull ItemStack remainder) {
            if (!this.updated && !remainder.m_41619_()) {
                for (int index = 0; index < QIOCraftingWindow.this.inputSlots.length; ++index) {
                    this.dummy.m_6836_(index, StackUtils.size(QIOCraftingWindow.this.inputSlots[index].getStack(), 1));
                }
                this.updated = true;
            }
        }

        public void updateInputsWithReplacement(int index, ItemStack old) {
            if (!this.updated) {
                for (int i = 0; i < QIOCraftingWindow.this.inputSlots.length; ++i) {
                    ItemStack stack = i == index ? old : QIOCraftingWindow.this.inputSlots[i].getStack();
                    this.dummy.m_6836_(i, StackUtils.size(stack, 1));
                }
                this.updated = true;
            }
        }

        public boolean isStackStillValid(Level world, ItemStack stack, int index) {
            this.updateInputs(stack);
            ItemStack old = this.dummy.m_8020_(index);
            this.dummy.m_6836_(index, StackUtils.size(stack, 1));
            if (QIOCraftingWindow.this.lastRecipe != null && QIOCraftingWindow.this.lastRecipe.m_5818_((Container)this.dummy, world)) {
                return true;
            }
            this.dummy.m_6836_(index, old);
            return false;
        }
    }

    private class QIOCraftingInventory
    extends CraftingContainer {
        public QIOCraftingInventory() {
            super(null, 0, 0);
        }

        public int m_6643_() {
            return QIOCraftingWindow.this.inputSlots.length;
        }

        public boolean m_7983_() {
            return Arrays.stream(QIOCraftingWindow.this.inputSlots).allMatch(BasicInventorySlot::isEmpty);
        }

        @NotNull
        public ItemStack m_8020_(int index) {
            CraftingWindowInventorySlot inputSlot;
            if (index >= 0 && index < this.m_6643_() && !(inputSlot = QIOCraftingWindow.this.getInputSlot(index)).isEmpty()) {
                return inputSlot.getStack().m_41777_();
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack m_8016_(int index) {
            if (index >= 0 && index < this.m_6643_()) {
                CraftingWindowInventorySlot inputSlot = QIOCraftingWindow.this.getInputSlot(index);
                ItemStack stored = inputSlot.getStack();
                inputSlot.setEmpty();
                return stored;
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack m_7407_(int index, int count) {
            if (index >= 0 && index < this.m_6643_()) {
                return QIOCraftingWindow.this.getInputSlot(index).extractItem(count, Action.EXECUTE, AutomationType.INTERNAL);
            }
            return ItemStack.f_41583_;
        }

        public void m_6836_(int index, @NotNull ItemStack stack) {
            if (index >= 0 && index < this.m_6643_()) {
                QIOCraftingWindow.this.getInputSlot(index).setStack(stack);
            }
        }

        public void m_6211_() {
            for (CraftingWindowInventorySlot inputSlot : QIOCraftingWindow.this.inputSlots) {
                inputSlot.setEmpty();
            }
        }

        public int m_39346_() {
            return 3;
        }

        public int m_39347_() {
            return 3;
        }

        public void m_5809_(@NotNull StackedContents helper) {
            boolean copyNeeded = helper.getClass() != StackedContents.class;
            for (CraftingWindowInventorySlot inputSlot : QIOCraftingWindow.this.inputSlots) {
                ItemStack stack = inputSlot.getStack();
                helper.m_36466_(copyNeeded ? stack.m_41777_() : stack);
            }
        }
    }

    private static class LastInsertTarget {
        private boolean wasHotBar = true;
        private int lastIndex;

        private LastInsertTarget() {
        }

        public ItemStack tryInserting(List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots, SelectedWindowData windowData, ItemStack toInsert) {
            toInsert = this.insertItem(hotBarSlots, toInsert, true, true, windowData);
            toInsert = this.insertItem(mainInventorySlots, toInsert, true, false, windowData);
            toInsert = this.insertItem(hotBarSlots, toInsert, false, true, windowData);
            toInsert = this.insertItem(mainInventorySlots, toInsert, false, false, windowData);
            return toInsert;
        }

        @NotNull
        private <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @NotNull ItemStack stack, boolean ignoreEmpty, boolean isHotBar, @Nullable SelectedWindowData selectedWindow) {
            if (stack.m_41619_()) {
                return stack;
            }
            int slotCount = slots.size();
            for (int i = ignoreEmpty && this.wasHotBar == isHotBar ? this.lastIndex : 0; i < slotCount; ++i) {
                Slot slot = (Slot)slots.get(i);
                if (ignoreEmpty != slot.m_6657_() || !((IInsertableSlot)slot).exists(selectedWindow) || !(stack = ((IInsertableSlot)slot).insertItem(stack, Action.EXECUTE)).m_41619_()) continue;
                this.wasHotBar = isHotBar;
                this.lastIndex = i;
                break;
            }
            return stack;
        }
    }
}

