/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.Collections;
import java.util.List;
import mekanism.common.integration.computer.ComputerArgumentHandler;
import org.jetbrains.annotations.Nullable;

public class BoundComputerMethod {
    private final String methodName;
    private final List<ThreadAwareMethodHandle> implementations;

    BoundComputerMethod(String methodName, List<ThreadAwareMethodHandle> implementations) {
        this.methodName = methodName;
        this.implementations = implementations;
    }

    void addMethodImplementation(ThreadAwareMethodHandle implementation) {
        this.implementations.add(implementation);
    }

    public List<ThreadAwareMethodHandle> getImplementations() {
        return Collections.unmodifiableList(this.implementations);
    }

    public <EXCEPTION extends Exception> SelectedMethodInfo findMatchingImplementation(ComputerArgumentHandler<EXCEPTION, ?> argumentHandler) throws EXCEPTION {
        if (this.implementations.size() == 1) {
            return this.validateArguments(argumentHandler, this.implementations.get(0), true);
        }
        for (ThreadAwareMethodHandle implementation : this.implementations) {
            SelectedMethodInfo selected = this.validateArguments(argumentHandler, implementation, false);
            if (selected == null) continue;
            return selected;
        }
        throw argumentHandler.error("Parameters do not match any signatures of %s.", this.methodName);
    }

    @Nullable
    public <EXCEPTION extends Exception> SelectedMethodInfo findMatchingImplementation(ComputerArgumentHandler<EXCEPTION, ?> argumentHandler, ThreadAwareMethodHandle overload) throws EXCEPTION {
        int overloadIndex = this.implementations.indexOf(overload);
        if (overloadIndex == -1) {
            throw argumentHandler.error("Method does not have corresponding overload", new Object[0]);
        }
        return this.validateArguments(argumentHandler, overload, true);
    }

    @Nullable
    private <EXCEPTION extends Exception> SelectedMethodInfo validateArguments(ComputerArgumentHandler<EXCEPTION, ?> argumentHandler, ThreadAwareMethodHandle overload, boolean error) throws EXCEPTION {
        MethodType methodType;
        int expectedCount;
        int argumentCount = argumentHandler.getCount();
        if (argumentCount != (expectedCount = (methodType = overload.methodHandle.type()).parameterCount())) {
            if (error) {
                throw argumentHandler.error("Mismatched parameter count. %s expected: '%d' arguments, but received: '%d' arguments.", this.methodName, expectedCount, argumentCount);
            }
            return null;
        }
        Object[] sanitizedArguments = new Object[expectedCount];
        for (int index = 0; index < expectedCount; ++index) {
            TypeDescriptor.OfField expectedType = methodType.parameterType(index);
            Object argument = argumentHandler.getArgument(index);
            if (argument == null) {
                if (error) {
                    throw argumentHandler.error("Invalid argument %d, %s expected %s but received null.", index, this.methodName, ((Class)expectedType).getSimpleName());
                }
                return null;
            }
            Class<?> argumentClass = argument.getClass();
            boolean matches = true;
            if (expectedType != argumentClass) {
                if (((Class)expectedType).isPrimitive()) {
                    if (argumentClass.isPrimitive()) {
                        if (BoundComputerMethod.isInvalidUpcast(argumentClass, expectedType)) {
                            matches = false;
                        }
                    } else {
                        Class<?> primitiveArgumentClass = BoundComputerMethod.getPrimitiveType(argumentClass);
                        if (expectedType != primitiveArgumentClass && BoundComputerMethod.isInvalidUpcast(primitiveArgumentClass, expectedType)) {
                            matches = false;
                        }
                    }
                } else if (!argumentClass.isPrimitive() || BoundComputerMethod.getPrimitiveType(expectedType) != argumentClass) {
                    matches = false;
                }
                if (!matches) {
                    Object sanitizedArgument = argumentHandler.sanitizeArgument((Class<?>)expectedType, argumentClass, argument);
                    if (sanitizedArgument == argument) {
                        if (error) {
                            throw argumentHandler.error("Invalid argument %d, %s expected %s but received type %s with value %s.", index, this.methodName, ((Class)expectedType).getSimpleName(), argumentClass.getSimpleName(), argument);
                        }
                        return null;
                    }
                    sanitizedArguments[index] = sanitizedArgument;
                }
            }
            if (!matches) continue;
            sanitizedArguments[index] = argument;
        }
        return new SelectedMethodInfo(overload, sanitizedArguments);
    }

    public <EXCEPTION extends Exception, RESULT> RESULT run(ComputerArgumentHandler<EXCEPTION, RESULT> argumentHandler, SelectedMethodInfo methodInfo) throws EXCEPTION {
        Object result;
        MethodHandle methodHandle = methodInfo.threadAwareMethodHandle.methodHandle;
        MethodType methodType = methodHandle.type();
        int argumentCount = methodType.parameterCount();
        try {
            result = switch (argumentCount) {
                case 0 -> methodHandle.invoke();
                case 1 -> methodHandle.invoke(methodInfo.arguments[0]);
                case 2 -> methodHandle.invoke(methodInfo.arguments[0], methodInfo.arguments[1]);
                case 3 -> methodHandle.invoke(methodInfo.arguments[0], methodInfo.arguments[1], methodInfo.arguments[2]);
                case 4 -> methodHandle.invoke(methodInfo.arguments[0], methodInfo.arguments[1], methodInfo.arguments[2], methodInfo.arguments[3]);
                case 5 -> methodHandle.invoke(methodInfo.arguments[0], methodInfo.arguments[1], methodInfo.arguments[2], methodInfo.arguments[3], methodInfo.arguments[4]);
                case 6 -> methodHandle.invoke(methodInfo.arguments[0], methodInfo.arguments[1], methodInfo.arguments[2], methodInfo.arguments[3], methodInfo.arguments[4], methodInfo.arguments[5]);
                case 7 -> methodHandle.invoke(methodInfo.arguments[0], methodInfo.arguments[1], methodInfo.arguments[2], methodInfo.arguments[3], methodInfo.arguments[4], methodInfo.arguments[5], methodInfo.arguments[6]);
                case 8 -> methodHandle.invoke(methodInfo.arguments[0], methodInfo.arguments[1], methodInfo.arguments[2], methodInfo.arguments[3], methodInfo.arguments[4], methodInfo.arguments[5], methodInfo.arguments[6], methodInfo.arguments[7]);
                case 9 -> methodHandle.invoke(methodInfo.arguments[0], methodInfo.arguments[1], methodInfo.arguments[2], methodInfo.arguments[3], methodInfo.arguments[4], methodInfo.arguments[5], methodInfo.arguments[6], methodInfo.arguments[7], methodInfo.arguments[8]);
                default -> methodHandle.invokeWithArguments(methodInfo.arguments);
            };
        }
        catch (Throwable e) {
            throw argumentHandler.error(e.getMessage(), new Object[0]);
        }
        TypeDescriptor.OfField returnType = methodType.returnType();
        if (returnType == Void.class || returnType == Void.TYPE) {
            return argumentHandler.noResult();
        }
        return argumentHandler.wrapResult(result);
    }

    private static boolean isInvalidUpcast(Class<?> argumentClass, Class<?> targetClass) {
        if (argumentClass == Byte.TYPE) {
            return targetClass != Short.TYPE && targetClass != Integer.TYPE && targetClass != Long.TYPE && targetClass != Float.TYPE && targetClass != Double.TYPE;
        }
        if (argumentClass == Character.TYPE || argumentClass == Short.TYPE) {
            return targetClass != Integer.TYPE && targetClass != Long.TYPE && targetClass != Float.TYPE && targetClass != Double.TYPE;
        }
        if (argumentClass == Integer.TYPE) {
            return targetClass != Long.TYPE && targetClass != Float.TYPE && targetClass != Double.TYPE;
        }
        if (argumentClass == Long.TYPE) {
            return targetClass != Float.TYPE && targetClass != Double.TYPE;
        }
        if (argumentClass == Float.TYPE) {
            return targetClass != Double.TYPE;
        }
        return true;
    }

    @Nullable
    private static Class<?> getPrimitiveType(Class<?> objectClass) {
        if (objectClass == Boolean.class) {
            return Boolean.TYPE;
        }
        if (objectClass == Character.class) {
            return Character.TYPE;
        }
        if (objectClass == Byte.class) {
            return Byte.TYPE;
        }
        if (objectClass == Short.class) {
            return Short.TYPE;
        }
        if (objectClass == Integer.class) {
            return Integer.TYPE;
        }
        if (objectClass == Long.class) {
            return Long.TYPE;
        }
        if (objectClass == Float.class) {
            return Float.TYPE;
        }
        if (objectClass == Double.class) {
            return Double.TYPE;
        }
        if (objectClass == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    public record ThreadAwareMethodHandle(MethodHandle methodHandle, List<String> paramNames, boolean threadSafe) {
        public Class<?> returnType() {
            return this.methodHandle.type().returnType();
        }

        public List<Class<?>> parameterTypes() {
            return this.methodHandle.type().parameterList();
        }
    }

    public static class SelectedMethodInfo {
        private final ThreadAwareMethodHandle threadAwareMethodHandle;
        private final Object[] arguments;

        private SelectedMethodInfo(ThreadAwareMethodHandle threadAwareMethodHandle, Object[] arguments) {
            this.threadAwareMethodHandle = threadAwareMethodHandle;
            this.arguments = arguments;
        }

        public ThreadAwareMethodHandle getMethod() {
            return this.threadAwareMethodHandle;
        }
    }
}

