/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.opencomputers2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.api.bus.device.rpc.RPCMethodGroup;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.opencomputers2.MekanismRPCMethodGroup;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class MekanismDevice<TILE extends BlockEntity>
implements RPCDevice {
    private final List<RPCMethodGroup> methodGroups;
    private final List<String> name;

    public static <TILE extends BlockEntity> MekanismDevice<TILE> create(TILE tile) {
        LinkedHashMap<String, BoundComputerMethod> boundMethods = new LinkedHashMap<String, BoundComputerMethod>();
        ((IComputerTile)tile).getComputerMethods(boundMethods);
        return new MekanismDevice<TILE>(tile, boundMethods);
    }

    private MekanismDevice(TILE tile, Map<String, BoundComputerMethod> boundMethods) {
        this.name = Collections.singletonList(((IComputerTile)tile).getComputerName());
        this.methodGroups = boundMethods.entrySet().stream().map(entry -> new MekanismRPCMethodGroup((String)entry.getKey(), (BoundComputerMethod)entry.getValue())).toList();
    }

    @NotNull
    public List<String> getTypeNames() {
        return this.name;
    }

    @NotNull
    public List<RPCMethodGroup> getMethodGroups() {
        return this.methodGroups;
    }
}

