/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.JSONConverter;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import java.util.List;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.creator.IFluidStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=FluidStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.FluidStackIngredient")
public class CrTFluidStackIngredient {
    private CrTFluidStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(Fluid fluid, int amount) {
        CrTIngredientHelper.assertValidAmount("FluidStackIngredients", amount);
        if (fluid == Fluids.f_76191_) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created from an empty fluid.");
        }
        return IngredientCreatorAccess.fluid().from(fluid, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(IFluidStack instance) {
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created from an empty stack.");
        }
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().from(instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(KnownTag<Fluid> fluidTag, int amount) {
        TagKey<Fluid> tag = CrTIngredientHelper.assertValidAndGet(fluidTag, amount, "FluidStackIngredients");
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(Many<KnownTag<Fluid>> fluidTag) {
        return CrTFluidStackIngredient.from((KnownTag<Fluid>)((KnownTag)fluidTag.getData()), fluidTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(CTFluidIngredient ingredient) {
        IFluidStackIngredientCreator ingredientCreator = IngredientCreatorAccess.fluid();
        return (FluidStackIngredient)ingredient.mapTo(ingredientCreator::from, ingredientCreator::from, ingredientCreator::from);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient createMulti(FluidStackIngredient ... ingredients) {
        return (FluidStackIngredient)CrTIngredientHelper.createMulti((String)"FluidStackIngredients", (IIngredientCreator)IngredientCreatorAccess.fluid(), (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(FluidStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    public static boolean testType(FluidStackIngredient _this, IFluidStack type) {
        return _this.testType(type.getInternal());
    }

    @ZenCodeType.Method
    public static boolean test(FluidStackIngredient _this, IFluidStack stack) {
        return _this.test(stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<IFluidStack> getRepresentations(FluidStackIngredient _this) {
        return CrTUtils.convertFluids(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static FluidStackIngredient or(FluidStackIngredient _this, FluidStackIngredient other) {
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().createMulti(new FluidStackIngredient[]{_this, other});
    }
}

