/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.EnergyConversionIRecipe;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToEnergy")
public abstract class ItemStackToEnergyRecipeManager
extends MekanismRecipeManager<ItemStackToEnergyRecipe> {
    protected ItemStackToEnergyRecipeManager(IMekanismRecipeTypeProvider<ItemStackToEnergyRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, FloatingLong output) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, output));
    }

    public final ItemStackToEnergyRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, FloatingLong output) {
        if (output.isZero()) {
            throw new IllegalArgumentException("Output must be greater than zero.");
        }
        return this.makeRecipeInternal(id, input, output.copyAsConst());
    }

    protected abstract ItemStackToEnergyRecipe makeRecipeInternal(ResourceLocation var1, ItemStackIngredient var2, FloatingLong var3);

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(ItemStackToEnergyRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return CrTUtils.describeOutputs(((ItemStackToEnergyRecipe)this.recipe).getOutputDefinition(), fl -> fl);
            }
        };
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToEnergy.EnergyConversion")
    public static class EnergyConversionRecipeManager
    extends ItemStackToEnergyRecipeManager {
        public static final EnergyConversionRecipeManager INSTANCE = new EnergyConversionRecipeManager();

        private EnergyConversionRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToEnergyRecipe, ?>)MekanismRecipeType.ENERGY_CONVERSION);
        }

        @Override
        protected ItemStackToEnergyRecipe makeRecipeInternal(ResourceLocation id, ItemStackIngredient input, FloatingLong output) {
            return new EnergyConversionIRecipe(id, input, output);
        }
    }
}

