/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.function.BiFunction;
import java.util.function.Function;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class PacketGuiButtonPress
implements IMekanismPacket {
    private final Type type;
    private ClickedItemButton itemButton;
    private ClickedTileButton tileButton;
    private ClickedEntityButton entityButton;
    private InteractionHand hand;
    private int entityID;
    private int extra;
    private BlockPos tilePosition;

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockEntity tile) {
        this(buttonClicked, tile.m_58899_());
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockEntity tile, int extra) {
        this(buttonClicked, tile.m_58899_(), extra);
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public PacketGuiButtonPress(ClickedItemButton buttonClicked, InteractionHand hand) {
        this.type = Type.ITEM;
        this.itemButton = buttonClicked;
        this.hand = hand;
    }

    public PacketGuiButtonPress(ClickedTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.type = Type.TILE;
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public PacketGuiButtonPress(ClickedEntityButton buttonClicked, Entity entity) {
        this(buttonClicked, entity.m_19879_());
    }

    public PacketGuiButtonPress(ClickedEntityButton buttonClicked, int entityID) {
        this.type = Type.ENTITY;
        this.entityButton = buttonClicked;
        this.entityID = entityID;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        MenuProvider provider;
        ItemStack stack;
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        if (this.type == Type.ENTITY) {
            MenuProvider provider2;
            Entity entity = player.f_19853_.m_6815_(this.entityID);
            if (entity != null && (provider2 = this.entityButton.getProvider(entity)) != null) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider2, buf -> buf.m_130130_(this.entityID));
            }
        } else if (this.type == Type.TILE) {
            MenuProvider provider3;
            TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.f_19853_, this.tilePosition);
            if (tile != null && (provider3 = this.tileButton.getProvider(tile, this.extra)) != null) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider3, buf -> {
                    buf.m_130064_(this.tilePosition);
                    buf.m_130130_(this.extra);
                });
            }
        } else if (this.type == Type.ITEM && (stack = player.m_21120_(this.hand)).m_41720_() instanceof IGuiItem && (provider = this.itemButton.getProvider(stack, this.hand)) != null) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buf -> {
                buf.m_130068_((Enum)this.hand);
                buf.m_130055_(stack);
            });
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        switch (this.type) {
            case ENTITY: {
                buffer.m_130068_((Enum)this.entityButton);
                buffer.m_130130_(this.entityID);
                break;
            }
            case TILE: {
                buffer.m_130068_((Enum)this.tileButton);
                buffer.m_130064_(this.tilePosition);
                buffer.m_130130_(this.extra);
                break;
            }
            case ITEM: {
                buffer.m_130068_((Enum)this.itemButton);
                buffer.m_130068_((Enum)this.hand);
            }
        }
    }

    public static PacketGuiButtonPress decode(FriendlyByteBuf buffer) {
        return switch ((Type)buffer.m_130066_(Type.class)) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ENTITY -> new PacketGuiButtonPress((ClickedEntityButton)buffer.m_130066_(ClickedEntityButton.class), buffer.m_130242_());
            case Type.TILE -> new PacketGuiButtonPress((ClickedTileButton)buffer.m_130066_(ClickedTileButton.class), buffer.m_130135_(), buffer.m_130242_());
            case Type.ITEM -> new PacketGuiButtonPress((ClickedItemButton)buffer.m_130066_(ClickedItemButton.class), (InteractionHand)buffer.m_130066_(InteractionHand.class));
        };
    }

    public static enum ClickedTileButton {
        BACK_BUTTON((tile, extra) -> {
            AttributeGui attributeGui = Attribute.get(tile.getBlockType(), AttributeGui.class);
            if (attributeGui != null) {
                return attributeGui.getProvider(tile);
            }
            return null;
        }),
        QIO_FREQUENCY_SELECT((tile, extra) -> MekanismContainerTypes.QIO_FREQUENCY_SELECT_TILE.getProvider(MekanismLang.QIO_FREQUENCY_SELECT, tile)),
        DIGITAL_MINER_CONFIG((tile, extra) -> MekanismContainerTypes.DIGITAL_MINER_CONFIG.getProvider(MekanismLang.MINER_CONFIG, tile)),
        TAB_MAIN((tile, extra) -> {
            if (tile instanceof TileEntityInductionCasing) {
                return MekanismContainerTypes.INDUCTION_MATRIX.getProvider(MekanismLang.MATRIX, tile);
            }
            if (tile instanceof TileEntityBoilerCasing) {
                return MekanismContainerTypes.THERMOELECTRIC_BOILER.getProvider(MekanismLang.BOILER, tile);
            }
            return null;
        }),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityInductionCasing) {
                return MekanismContainerTypes.MATRIX_STATS.getProvider(MekanismLang.MATRIX_STATS, tile);
            }
            if (tile instanceof TileEntityBoilerCasing) {
                return MekanismContainerTypes.BOILER_STATS.getProvider(MekanismLang.BOILER_STATS, tile);
            }
            return null;
        });

        private final BiFunction<TileEntityMekanism, Integer, MenuProvider> providerFromTile;

        private ClickedTileButton(BiFunction<TileEntityMekanism, Integer, MenuProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public MenuProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }

    public static enum Type {
        TILE,
        ITEM,
        ENTITY;

    }

    public static enum ClickedItemButton {
        BACK_BUTTON((stack, hand) -> {
            Item patt5647$temp = stack.m_41720_();
            if (patt5647$temp instanceof IGuiItem) {
                IGuiItem guiItem = (IGuiItem)patt5647$temp;
                return guiItem.getContainerType().getProvider(stack.m_41786_(), (InteractionHand)hand, (ItemStack)stack);
            }
            return null;
        }),
        QIO_FREQUENCY_SELECT((stack, hand) -> MekanismContainerTypes.QIO_FREQUENCY_SELECT_ITEM.getProvider(MekanismLang.QIO_FREQUENCY_SELECT, (InteractionHand)hand, (ItemStack)stack));

        private final BiFunction<ItemStack, InteractionHand, MenuProvider> providerFromItem;

        private ClickedItemButton(BiFunction<ItemStack, InteractionHand, MenuProvider> providerFromItem) {
            this.providerFromItem = providerFromItem;
        }

        public MenuProvider getProvider(ItemStack stack, InteractionHand hand) {
            return this.providerFromItem.apply(stack, hand);
        }
    }

    public static enum ClickedEntityButton {
        ROBIT_CRAFTING(entity -> MekanismContainerTypes.CRAFTING_ROBIT.getProvider(MekanismLang.ROBIT_CRAFTING, entity)),
        ROBIT_INVENTORY(entity -> MekanismContainerTypes.INVENTORY_ROBIT.getProvider(MekanismLang.ROBIT_INVENTORY, entity)),
        ROBIT_MAIN(entity -> MekanismContainerTypes.MAIN_ROBIT.getProvider(MekanismLang.ROBIT, entity)),
        ROBIT_REPAIR(entity -> MekanismContainerTypes.REPAIR_ROBIT.getProvider(MekanismLang.ROBIT_REPAIR, entity)),
        ROBIT_SMELTING(entity -> MekanismContainerTypes.SMELTING_ROBIT.getProvider(MekanismLang.ROBIT_SMELTING, entity));

        private final Function<Entity, MenuProvider> providerFromEntity;

        private ClickedEntityButton(Function<Entity, MenuProvider> providerFromEntity) {
            this.providerFromEntity = providerFromEntity;
        }

        public MenuProvider getProvider(Entity entity) {
            return this.providerFromEntity.apply(entity);
        }
    }
}

