/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.providers.IItemProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.CreativeTabMekanism;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.item.ItemModule;
import mekanism.common.registration.WrappedDeferredRegister;
import mekanism.common.registration.impl.EntityTypeRegistryObject;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.registration.impl.ModuleRegistryObject;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ItemDeferredRegister
extends WrappedDeferredRegister<Item> {
    private static final CreativeTabMekanism tabMekanism = new CreativeTabMekanism();
    private final List<IItemProvider> allItems = new ArrayList<IItemProvider>();

    public ItemDeferredRegister(String modid) {
        super(modid, ForgeRegistries.ITEMS);
    }

    public static Item.Properties getMekBaseProperties() {
        return new Item.Properties().m_41491_((CreativeModeTab)tabMekanism);
    }

    public ItemRegistryObject<Item> register(String name) {
        return this.register(name, Item::new);
    }

    public ItemRegistryObject<Item> registerUnburnable(String name) {
        return this.registerUnburnable(name, Item::new);
    }

    public ItemRegistryObject<Item> register(String name, Rarity rarity) {
        return this.register(name, (Item.Properties properties) -> new Item(properties.m_41497_(rarity)));
    }

    public ItemRegistryObject<Item> register(String name, final EnumColor color) {
        return this.register(name, (Item.Properties properties) -> new Item((Item.Properties)properties){

            @NotNull
            public Component m_7626_(@NotNull ItemStack stack) {
                return TextComponentUtil.build(color, super.m_7626_(stack));
            }
        });
    }

    public ItemRegistryObject<ItemModule> registerModule(ModuleRegistryObject<?> moduleDataSupplier) {
        return this.register("module_" + moduleDataSupplier.getInternalRegistryName(), () -> ModuleHelper.INSTANCE.createModuleItem(moduleDataSupplier, ItemDeferredRegister.getMekBaseProperties()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(ItemDeferredRegister.getMekBaseProperties()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> registerUnburnable(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(ItemDeferredRegister.getMekBaseProperties().m_41486_()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Supplier<? extends ITEM> sup) {
        ItemRegistryObject registeredItem = this.register(name, sup, ItemRegistryObject::new);
        this.allItems.add(registeredItem);
        return registeredItem;
    }

    public <ENTITY extends Mob> ItemRegistryObject<ForgeSpawnEggItem> registerSpawnEgg(EntityTypeRegistryObject<ENTITY> entityTypeProvider, int primaryColor, int secondaryColor) {
        return this.register(entityTypeProvider.getInternalRegistryName() + "_spawn_egg", (Item.Properties props) -> new ForgeSpawnEggItem((Supplier)entityTypeProvider, primaryColor, secondaryColor, props));
    }

    public List<IItemProvider> getAllItems() {
        return Collections.unmodifiableList(this.allItems);
    }
}

