/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtils {
    private StorageUtils() {
    }

    public static void addStoredEnergy(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap) {
        StorageUtils.addStoredEnergy(stack, tooltip, showMissingCap, MekanismLang.STORED_ENERGY);
    }

    public static void addStoredEnergy(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, ILangEntry langEntry) {
        Optional capability = stack.getCapability(Capabilities.STRICT_ENERGY).resolve();
        if (capability.isPresent()) {
            IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)capability.get();
            int energyContainerCount = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < energyContainerCount; ++container) {
                tooltip.add((Component)langEntry.translateColored(EnumColor.BRIGHT_GREEN, EnumColor.GRAY, EnergyDisplay.of(energyHandlerItem.getEnergy(container), energyHandlerItem.getMaxEnergy(container))));
            }
        } else if (showMissingCap) {
            tooltip.add((Component)langEntry.translateColored(EnumColor.BRIGHT_GREEN, EnumColor.GRAY, EnergyDisplay.ZERO));
        }
    }

    public static void addStoredGas(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, boolean showAttributes) {
        StorageUtils.addStoredGas(stack, tooltip, showMissingCap, showAttributes, MekanismLang.NO_GAS);
    }

    public static void addStoredGas(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, boolean showAttributes, ILangEntry emptyLangEntry) {
        StorageUtils.addStoredChemical(stack, tooltip, showMissingCap, showAttributes, emptyLangEntry, stored -> {
            if (stored.isEmpty()) {
                return emptyLangEntry.translateColored(EnumColor.GRAY, new Object[0]);
            }
            return MekanismLang.STORED.translateColored(EnumColor.ORANGE, EnumColor.ORANGE, stored, EnumColor.GRAY, MekanismLang.GENERIC_MB.translate(TextUtils.format(stored.getAmount())));
        }, Capabilities.GAS_HANDLER);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> void addStoredChemical(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, boolean showAttributes, ILangEntry emptyLangEntry, Function<STACK, Component> storedFunction, Capability<HANDLER> capability) {
        Optional cap = stack.getCapability(capability).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                Object chemicalInTank = handler.getChemicalInTank(tank);
                tooltip.add(storedFunction.apply(chemicalInTank));
                if (!showAttributes) continue;
                ChemicalUtil.addAttributeTooltips(tooltip, ((ChemicalStack)chemicalInTank).getType());
            }
        } else if (showMissingCap) {
            tooltip.add((Component)emptyLangEntry.translate(new Object[0]));
        }
    }

    public static void addStoredFluid(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap) {
        StorageUtils.addStoredFluid(stack, tooltip, showMissingCap, MekanismLang.NO_FLUID_TOOLTIP);
    }

    public static void addStoredFluid(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, ILangEntry emptyLangEntry) {
        StorageUtils.addStoredFluid(stack, tooltip, showMissingCap, emptyLangEntry, stored -> {
            if (stored.isEmpty()) {
                return emptyLangEntry.translateColored(EnumColor.GRAY, new Object[0]);
            }
            return MekanismLang.STORED.translateColored(EnumColor.ORANGE, EnumColor.ORANGE, stored, EnumColor.GRAY, MekanismLang.GENERIC_MB.translate(TextUtils.format(stored.getAmount())));
        });
    }

    public static void addStoredFluid(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, ILangEntry emptyLangEntry, Function<FluidStack, Component> storedFunction) {
        Optional cap = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (cap.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)cap.get();
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                tooltip.add(storedFunction.apply(handler.getFluidInTank(tank)));
            }
        } else if (showMissingCap) {
            tooltip.add((Component)emptyLangEntry.translate(new Object[0]));
        }
    }

    public static void addStoredSubstance(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean isCreative) {
        MekanismLang type;
        long amount;
        Object contents;
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT(stack);
        GasStack gasStack = StorageUtils.getStoredGasFromNBT(stack);
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromNBT(stack);
        PigmentStack pigmentStack = StorageUtils.getStoredPigmentFromNBT(stack);
        SlurryStack slurryStack = StorageUtils.getStoredSlurryFromNBT(stack);
        if (fluidStack.isEmpty() && gasStack.isEmpty() && infusionStack.isEmpty() && pigmentStack.isEmpty() && slurryStack.isEmpty()) {
            tooltip.add((Component)MekanismLang.EMPTY.translate(new Object[0]));
            return;
        }
        if (!fluidStack.isEmpty()) {
            contents = fluidStack;
            amount = fluidStack.getAmount();
            type = MekanismLang.LIQUID;
        } else {
            ChemicalStack chemicalStack;
            if (!gasStack.isEmpty()) {
                chemicalStack = gasStack;
                type = MekanismLang.GAS;
            } else if (!infusionStack.isEmpty()) {
                chemicalStack = infusionStack;
                type = MekanismLang.INFUSE_TYPE;
            } else if (!pigmentStack.isEmpty()) {
                chemicalStack = pigmentStack;
                type = MekanismLang.PIGMENT;
            } else if (!slurryStack.isEmpty()) {
                chemicalStack = slurryStack;
                type = MekanismLang.SLURRY;
            } else {
                throw new IllegalStateException("Unknown chemical");
            }
            contents = chemicalStack;
            amount = chemicalStack.getAmount();
        }
        if (isCreative) {
            tooltip.add((Component)type.translateColored(EnumColor.YELLOW, EnumColor.ORANGE, MekanismLang.GENERIC_STORED.translate(contents, EnumColor.GRAY, MekanismLang.INFINITE)));
        } else {
            tooltip.add((Component)type.translateColored(EnumColor.YELLOW, EnumColor.ORANGE, MekanismLang.GENERIC_STORED_MB.translate(contents, EnumColor.GRAY, TextUtils.format(amount))));
        }
    }

    @NotNull
    public static FluidStack getStoredFluidFromNBT(ItemStack stack) {
        BasicFluidTank tank = BasicFluidTank.create(Integer.MAX_VALUE, null);
        ItemDataUtils.readContainers(stack, "FluidTanks", Collections.singletonList(tank));
        return tank.getFluid();
    }

    @NotNull
    public static GasStack getStoredGasFromNBT(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromNBT(stack, ChemicalTankBuilder.GAS.createDummy(Long.MAX_VALUE), "GasTanks");
    }

    @NotNull
    public static InfusionStack getStoredInfusionFromNBT(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromNBT(stack, ChemicalTankBuilder.INFUSION.createDummy(Long.MAX_VALUE), "InfusionTanks");
    }

    @NotNull
    public static PigmentStack getStoredPigmentFromNBT(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromNBT(stack, ChemicalTankBuilder.PIGMENT.createDummy(Long.MAX_VALUE), "PigmentTanks");
    }

    @NotNull
    public static SlurryStack getStoredSlurryFromNBT(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromNBT(stack, ChemicalTankBuilder.SLURRY.createDummy(Long.MAX_VALUE), "SlurryTanks");
    }

    @NotNull
    private static <STACK extends ChemicalStack<?>> STACK getStoredChemicalFromNBT(ItemStack stack, IChemicalTank<?, STACK> tank, String tag) {
        ItemDataUtils.readContainers(stack, tag, Collections.singletonList(tank));
        return tank.getStack();
    }

    public static FloatingLong getStoredEnergyFromNBT(ItemStack stack) {
        BasicEnergyContainer container = BasicEnergyContainer.create(FloatingLong.MAX_VALUE, null);
        ItemDataUtils.readContainers(stack, "EnergyContainers", Collections.singletonList(container));
        return container.getEnergy();
    }

    public static ItemStack getFilledEnergyVariant(ItemStack toFill, CachedFloatingLongValue capacity) {
        return StorageUtils.getFilledEnergyVariant(toFill, (FloatingLong)capacity.getOrDefault());
    }

    public static ItemStack getFilledEnergyVariant(ItemStack toFill, FloatingLong capacity) {
        BasicEnergyContainer container = BasicEnergyContainer.create(capacity, null);
        container.setEnergy(capacity);
        ItemDataUtils.writeContainers(toFill, "EnergyContainers", Collections.singletonList(container));
        return toFill;
    }

    @Nullable
    public static IEnergyContainer getEnergyContainer(ItemStack stack, int container) {
        IStrictEnergyHandler energyHandlerItem;
        Optional energyCapability;
        if (!stack.m_41619_() && (energyCapability = stack.getCapability(Capabilities.STRICT_ENERGY).resolve()).isPresent() && (energyHandlerItem = (IStrictEnergyHandler)energyCapability.get()) instanceof IMekanismStrictEnergyHandler) {
            IMekanismStrictEnergyHandler energyHandler = (IMekanismStrictEnergyHandler)energyHandlerItem;
            return energyHandler.getEnergyContainer(container, null);
        }
        return null;
    }

    public static double getEnergyRatio(ItemStack stack) {
        IEnergyContainer container = StorageUtils.getEnergyContainer(stack, 0);
        double ratio = 0.0;
        if (container != null) {
            ratio = container.getEnergy().divideToLevel(container.getMaxEnergy());
        }
        return ratio;
    }

    public static Component getEnergyPercent(ItemStack stack, boolean colorText) {
        return StorageUtils.getStoragePercent(StorageUtils.getEnergyRatio(stack), colorText);
    }

    public static Component getStoragePercent(double ratio, boolean colorText) {
        Component text = TextUtils.getPercent(ratio);
        if (!colorText) {
            return text;
        }
        EnumColor color = ratio < (double)0.01f ? EnumColor.DARK_RED : (ratio < (double)0.1f ? EnumColor.RED : (ratio < 0.25 ? EnumColor.ORANGE : (ratio < 0.5 ? EnumColor.YELLOW : EnumColor.BRIGHT_GREEN)));
        return TextComponentUtil.build(color, text);
    }

    public static int getBarWidth(ItemStack stack) {
        return MathUtils.clampToInt(Math.round(13.0 - 13.0 * StorageUtils.getDurabilityForDisplay(stack)));
    }

    private static double getDurabilityForDisplay(ItemStack stack) {
        double bestRatio = 0.0;
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.GAS_HANDLER);
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.INFUSION_HANDLER);
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.PIGMENT_HANDLER);
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.SLURRY_HANDLER);
        Optional fluidCapability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (fluidCapability.isPresent()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidCapability.get();
            int tanks = fluidHandlerItem.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(fluidHandlerItem.getFluidInTank(tank).getAmount(), fluidHandlerItem.getTankCapacity(tank)));
            }
        }
        return 1.0 - bestRatio;
    }

    public static int getEnergyBarWidth(ItemStack stack) {
        return MathUtils.clampToInt(Math.round(13.0 - 13.0 * StorageUtils.getEnergyDurabilityForDisplay(stack)));
    }

    private static double getEnergyDurabilityForDisplay(ItemStack stack) {
        double bestRatio = 0.0;
        Optional energyCapability = stack.getCapability(Capabilities.STRICT_ENERGY).resolve();
        if (energyCapability.isPresent()) {
            IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)energyCapability.get();
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                bestRatio = Math.max(bestRatio, energyHandlerItem.getEnergy(container).divideToLevel(energyHandlerItem.getMaxEnergy(container)));
            }
        }
        return 1.0 - bestRatio;
    }

    private static double calculateRatio(ItemStack stack, double bestRatio, Capability<? extends IChemicalHandler<?, ?>> capability) {
        Optional cap = stack.getCapability(capability).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(((ChemicalStack)handler.getChemicalInTank(tank)).getAmount(), handler.getTankCapacity(tank)));
            }
        }
        return bestRatio;
    }

    public static double getRatio(long amount, long capacity) {
        return capacity == 0L ? 1.0 : (double)amount / (double)capacity;
    }

    public static void mergeFluidTanks(List<IExtendedFluidTank> tanks, List<IExtendedFluidTank> toAdd, List<FluidStack> rejects) {
        if (tanks.size() != toAdd.size()) {
            throw new IllegalArgumentException("Mismatched tank count");
        }
        for (int i = 0; i < toAdd.size(); ++i) {
            int remaining;
            IExtendedFluidTank mergeTank = toAdd.get(i);
            if (mergeTank.isEmpty()) continue;
            IExtendedFluidTank tank = tanks.get(i);
            FluidStack mergeStack = mergeTank.getFluid();
            if (tank.isEmpty()) {
                int capacity = tank.getCapacity();
                if (mergeStack.getAmount() <= capacity) {
                    tank.setStack(mergeStack);
                    continue;
                }
                tank.setStack(new FluidStack(mergeStack, capacity));
                remaining = mergeStack.getAmount() - capacity;
                if (remaining <= 0) continue;
                rejects.add(new FluidStack(mergeStack, remaining));
                continue;
            }
            if (tank.isFluidEqual(mergeStack)) {
                int amount = tank.growStack(mergeStack.getAmount(), Action.EXECUTE);
                remaining = mergeStack.getAmount() - amount;
                if (remaining <= 0) continue;
                rejects.add(new FluidStack(mergeStack, remaining));
                continue;
            }
            rejects.add(mergeStack);
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> void mergeTanks(List<TANK> tanks, List<TANK> toAdd, List<STACK> rejects) {
        if (tanks.size() != toAdd.size()) {
            throw new IllegalArgumentException("Mismatched tank count");
        }
        for (int i = 0; i < toAdd.size(); ++i) {
            long remaining;
            IChemicalTank mergeTank = (IChemicalTank)toAdd.get(i);
            if (mergeTank.isEmpty()) continue;
            IChemicalTank tank = (IChemicalTank)tanks.get(i);
            Object mergeStack = mergeTank.getStack();
            if (tank.isEmpty()) {
                long capacity = tank.getCapacity();
                if (((ChemicalStack)mergeStack).getAmount() <= capacity) {
                    tank.setStack(mergeStack);
                    continue;
                }
                tank.setStack(ChemicalUtil.copyWithAmount(mergeStack, capacity));
                remaining = ((ChemicalStack)mergeStack).getAmount() - capacity;
                if (remaining <= 0L) continue;
                rejects.add(ChemicalUtil.copyWithAmount(mergeStack, remaining));
                continue;
            }
            if (tank.isTypeEqual(mergeStack)) {
                long amount = tank.growStack(((ChemicalStack)mergeStack).getAmount(), Action.EXECUTE);
                remaining = ((ChemicalStack)mergeStack).getAmount() - amount;
                if (remaining <= 0L) continue;
                rejects.add(ChemicalUtil.copyWithAmount(mergeStack, remaining));
                continue;
            }
            rejects.add(mergeStack);
        }
    }

    public static void mergeContainers(IEnergyContainer container, IEnergyContainer mergeContainer) {
        container.setEnergy(container.getEnergy().add(mergeContainer.getEnergy()));
    }

    public static void mergeContainers(IHeatCapacitor capacitor, IHeatCapacitor mergeCapacitor) {
        capacitor.setHeat(capacitor.getHeat() + mergeCapacitor.getHeat());
        if (capacitor instanceof BasicHeatCapacitor) {
            BasicHeatCapacitor heatCapacitor = (BasicHeatCapacitor)capacitor;
            heatCapacitor.setHeatCapacity(capacitor.getHeatCapacity() + mergeCapacitor.getHeatCapacity(), false);
        }
    }
}

