/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.UnionMultiblock;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;

public class UnionMBManualData
implements ClientMultiblocks.MultiblockManualData {
    private final Supplier<NonNullList<ItemStack>> materials = Suppliers.memoize(() -> {
        NonNullList stacks = NonNullList.m_122779_();
        for (UnionMultiblock.TransformedMultiblock part : parts) {
            for (ItemStack stack : ClientMultiblocks.get(part.multiblock()).getTotalMaterials()) {
                boolean added = false;
                for (ItemStack ex : stacks) {
                    if (!ItemStack.m_41746_((ItemStack)ex, (ItemStack)stack)) continue;
                    ex.m_41769_(stack.m_41613_());
                    added = true;
                    break;
                }
                if (added) continue;
                stacks.add((Object)stack.m_41777_());
            }
        }
        return stacks;
    });
    private final List<ClientSubMultiblock> partData;

    public UnionMBManualData(List<UnionMultiblock.TransformedMultiblock> parts, Vec3i min) {
        this.partData = parts.stream().map(mb -> UnionMBManualData.toClientMultiblock(mb, min)).filter(p -> p.mbData().canRenderFormedStructure()).toList();
    }

    @Override
    public NonNullList<ItemStack> getTotalMaterials() {
        return this.materials.get();
    }

    @Override
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    public void renderFormedStructure(PoseStack transform, MultiBufferSource buffer) {
        for (ClientSubMultiblock part : this.partData) {
            transform.m_85836_();
            Vec3i offset = part.offset();
            transform.m_85837_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
            transform.m_85837_(0.5, 0.5, 0.5);
            transform.m_85845_(part.rotation());
            transform.m_85837_(-0.5, -0.5, -0.5);
            part.mbData().renderFormedStructure(transform, buffer);
            transform.m_85849_();
        }
    }

    private static float getAngle(Rotation rot) {
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> 0.0f;
            case Rotation.CLOCKWISE_90 -> -90.0f;
            case Rotation.CLOCKWISE_180 -> 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> 90.0f;
        };
    }

    private static ClientSubMultiblock toClientMultiblock(UnionMultiblock.TransformedMultiblock mb, Vec3i min) {
        ClientMultiblocks.MultiblockManualData data = ClientMultiblocks.get(mb.multiblock());
        Vec3i offset = mb.offset().m_121996_(min);
        Quaternion rotation = new Quaternion(0.0f, UnionMBManualData.getAngle(mb.rotation()), 0.0f, true);
        return new ClientSubMultiblock(data, offset, rotation);
    }

    private record ClientSubMultiblock(ClientMultiblocks.MultiblockManualData mbData, Vec3i offset, Quaternion rotation) {
    }
}

