/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MetalPressBlockEntity
extends PoweredMultiblockBlockEntity<MetalPressBlockEntity, MetalPressRecipe>
implements IEBlockInterfaces.IPlayerInteraction,
ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds,
IEClientTickableBE {
    public static final float TRANSLATION_DISTANCE = 2.5f;
    private static final float STANDARD_TRANSPORT_TIME = 20.0f;
    private static final float STANDARD_PRESS_TIME = 3.75f;
    private static final float MIN_CYCLE_TIME = 60.0f;
    public ItemStack mold = ItemStack.f_41583_;
    private final CapabilityReference<IItemHandler> outputCap = CapabilityReference.forBlockEntityAt(this, this::getOutputPos, ForgeCapabilities.ITEM_HANDLER);
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new PoweredMultiblockBlockEntity.MultiblockInventoryHandler_DirectProcessing(this)));

    public MetalPressBlockEntity(BlockEntityType<MetalPressBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.METAL_PRESS, 16000, true, type, pos, state);
    }

    @Override
    public void tickClient() {
        if (this.isRSDisabled()) {
            return;
        }
        for (MultiblockProcess process : this.processQueue) {
            float maxTicks = process.getMaxTicks(this.f_58857_);
            float transportTime = MetalPressBlockEntity.getTransportTime(maxTicks);
            float pressTime = MetalPressBlockEntity.getPressTime(maxTicks);
            float fProcess = process.processTick;
            Player localPlayer = ImmersiveEngineering.proxy.getClientPlayer();
            if (fProcess >= transportTime && fProcess < transportTime + 1.0f) {
                this.f_58857_.m_5594_(localPlayer, this.m_58899_(), (SoundEvent)IESounds.metalpress_piston.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            if (fProcess >= transportTime + pressTime && fProcess < transportTime + pressTime + 1.0f) {
                this.f_58857_.m_5594_(localPlayer, this.m_58899_(), (SoundEvent)IESounds.metalpress_smash.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            if (!(fProcess >= maxTicks - transportTime) || !(fProcess < maxTicks - transportTime + 1.0f)) continue;
            this.f_58857_.m_5594_(localPlayer, this.m_58899_(), (SoundEvent)IESounds.metalpress_piston.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.mold = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("mold"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.mold.m_41619_()) {
            nbt.m_128365_("mold", (Tag)this.mold.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        MetalPressBlockEntity master = (MetalPressBlockEntity)this.master();
        if (master != null) {
            if (player.m_6144_() && !master.mold.m_41619_()) {
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, master.mold.m_41777_());
                } else if (!this.f_58857_.f_46443_) {
                    player.m_5552_(master.mold.m_41777_(), 0.0f);
                }
                master.mold = ItemStack.f_41583_;
                this.updateMasterBlock(null, true);
                return true;
            }
            if (MetalPressRecipe.isValidMold(this.f_58857_, heldItem)) {
                ItemStack tempMold = !master.mold.m_41619_() ? master.mold.m_41777_() : ItemStack.f_41583_;
                master.mold = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1);
                heldItem.m_41774_(1);
                if (heldItem.m_41613_() <= 0) {
                    heldItem = ItemStack.f_41583_;
                } else {
                    player.m_21008_(hand, heldItem);
                }
                if (!tempMold.m_41619_()) {
                    if (heldItem.m_41619_()) {
                        player.m_21008_(hand, tempMold);
                    } else if (!this.f_58857_.f_46443_) {
                        player.m_5552_(tempMold, 0.0f);
                    }
                }
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    @Override
    protected MultiblockProcess<MetalPressRecipe> loadProcessFromNBT(CompoundTag tag) {
        ResourceLocation id = new ResourceLocation(tag.m_128461_("recipe"));
        if (tag.m_128425_("baseRecipe", 8)) {
            ResourceLocation baseRecipeName = new ResourceLocation(tag.m_128461_("baseRecipe"));
            return MultiblockProcessInWorld.load(id, (level, pressId) -> {
                CraftingRecipe baseRecipe = MetalPressPackingRecipes.CRAFTING_RECIPE_MAP.getById((Level)level, baseRecipeName);
                if (baseRecipe != null) {
                    return MetalPressPackingRecipes.getRecipeDelegate(baseRecipe, pressId);
                }
                return null;
            }, tag);
        }
        return MultiblockProcessInWorld.load(id, this::getRecipeForId, tag);
    }

    @Override
    protected CompoundTag writeProcessToNBT(MultiblockProcess<?> process) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("recipe", process.getRecipeId().toString());
        Object obj = process.getRecipe(this.f_58857_);
        if (obj instanceof MetalPressPackingRecipes.RecipeDelegate) {
            MetalPressPackingRecipes.RecipeDelegate delegate = (MetalPressPackingRecipes.RecipeDelegate)obj;
            tag.m_128359_("baseRecipe", delegate.baseRecipe.m_6423_().toString());
        }
        tag.m_128405_("process_processTick", process.processTick);
        process.writeExtraDataToNBT(tag);
        return tag;
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (this.posInMultiblock.m_123342_() == 1 && this.posInMultiblock.m_123341_() % 2 == 0) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        }
        return Shapes.m_83144_();
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (new BlockPos(0, 1, 0).equals((Object)this.posInMultiblock) && !world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (entity.m_6084_() && !itemEntity.m_32055_().m_41619_()) {
                MetalPressBlockEntity master = (MetalPressBlockEntity)this.master();
                if (master == null) {
                    return;
                }
                ItemStack stack = itemEntity.m_32055_();
                if (stack.m_41619_()) {
                    return;
                }
                MetalPressRecipe recipe = master.findRecipeForInsertion(stack);
                if (recipe == null) {
                    return;
                }
                float transformationPoint = 0.5f;
                ItemStack displayStack = recipe.getDisplayStack(stack);
                MultiblockProcessInWorld<MetalPressRecipe> process = new MultiblockProcessInWorld<MetalPressRecipe>(recipe, this::getRecipeForId, transformationPoint, Utils.createNonNullItemStackListFromItemStack(displayStack));
                if (master.addProcessToQueue(process, true)) {
                    master.addProcessToQueue(process, false);
                    ItemStack remaining = stack.m_41777_();
                    remaining.m_41774_(displayStack.m_41613_());
                    itemEntity.m_32045_(remaining);
                    if (remaining.m_41619_()) {
                        entity.m_146870_();
                    }
                }
            }
        }
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(1, 2, 0, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 0));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<MetalPressRecipe> process) {
        return true;
    }

    private DirectionalBlockPos getOutputPos() {
        return new DirectionalBlockPos(this.f_58858_.m_5484_(this.getFacing(), 2), this.getFacing());
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).m_41619_()) {
            DirectionalBlockPos outPos = this.getOutputPos();
            Utils.dropStackAtPos(this.f_58857_, outPos.position(), output, outPos.side());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<MetalPressRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 3;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 3;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<MetalPressRecipe> process) {
        float maxTicks = process.getMaxTicks(this.f_58857_);
        return 1.0f - (MetalPressBlockEntity.getTransportTime(maxTicks) + MetalPressBlockEntity.getPressTime(maxTicks)) / maxTicks;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public Stream<ItemStack> getDroppedItems() {
        return Stream.of(this.mold);
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && new BlockPos(0, 1, 0).equals((Object)this.posInMultiblock) && facing == this.getFacing().m_122424_()) {
            return this.insertionHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MetalPressRecipe findRecipeForInsertion(ItemStack inserting) {
        return MetalPressRecipe.findRecipe(this.mold, inserting, this.f_58857_);
    }

    @Override
    protected MetalPressRecipe getRecipeForId(Level level, ResourceLocation id) {
        return MetalPressRecipe.STANDARD_RECIPES.getById(level, id);
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(2, 1, 0).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getFacing()};
        }
        return new Direction[0];
    }

    public static float getTransportTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 20.0f;
        }
        return processMaxTicks * 20.0f / 60.0f;
    }

    public static float getPressTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 3.75f;
        }
        return processMaxTicks * 3.75f / 60.0f;
    }
}

