/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;

public class RGBColourationRecipe
implements CraftingRecipe {
    private final Ingredient target;
    private final String colorKey;
    private final ResourceLocation id;

    public RGBColourationRecipe(Ingredient target, String colorKey, ResourceLocation id) {
        this.target = target;
        this.colorKey = colorKey;
        this.id = id;
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        ItemStack itemToColour = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (itemToColour.m_41619_() && this.target.test(stackInSlot)) {
                itemToColour = stackInSlot;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                list.add(stackInSlot);
                continue;
            }
            return false;
        }
        return !itemToColour.m_41619_() && !list.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        ItemStack itemToColour = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (itemToColour.m_41619_() && this.target.test(stackInSlot)) {
                itemToColour = stackInSlot;
                int colour = itemToColour.m_41782_() && itemToColour.m_41784_().m_128425_(this.colorKey, 3) ? itemToColour.m_41784_().m_128451_(this.colorKey) : 0xFFFFFF;
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (!Utils.isDye(stackInSlot)) continue;
            float[] afloat = Utils.getDye(stackInSlot).m_41068_();
            int r = (int)(afloat[0] * 255.0f);
            int g = (int)(afloat[1] * 255.0f);
            int b = (int)(afloat[2] * 255.0f);
            j += Math.max(r, Math.max(g, b));
            colourArray[0] = colourArray[0] + r;
            colourArray[1] = colourArray[1] + g;
            colourArray[2] = colourArray[2] + b;
            ++totalColourSets;
        }
        if (!itemToColour.m_41619_()) {
            ItemStack newItem = ItemHandlerHelper.copyStackWithSize((ItemStack)itemToColour, (int)1);
            int r = colourArray[0] / totalColourSets;
            int g = colourArray[1] / totalColourSets;
            int b = colourArray[2] / totalColourSets;
            float colourMod = (float)j / (float)totalColourSets;
            float highestColour = Math.max(r, Math.max(g, b));
            r = (int)((float)r * colourMod / highestColour);
            g = (int)((float)g * colourMod / highestColour);
            b = (int)((float)b * colourMod / highestColour);
            int newColour = (r << 8) + g;
            newColour = (newColour << 8) + b;
            newItem.m_41784_().m_128405_(this.colorKey, newColour);
            return newItem;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.RGB_SERIALIZER.get();
    }

    public Ingredient getTarget() {
        return this.target;
    }

    public String getColorKey() {
        return this.colorKey;
    }
}

