/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;

public class SawmillRecipeSerializer
extends IERecipeSerializer<SawmillRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.SAWMILL);
    }

    @Override
    public SawmillRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        Lazy<ItemStack> output = SawmillRecipeSerializer.readOutput(json.get("result"));
        Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
        Lazy<ItemStack> stripped = IESerializableRecipe.LAZY_EMPTY;
        if (json.has("stripped")) {
            stripped = SawmillRecipeSerializer.readOutput(json.get("stripped"));
        }
        JsonArray array = json.getAsJsonArray("secondaries");
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        SawmillRecipe recipe = IEServerConfig.MACHINES.sawmillConfig.apply(new SawmillRecipe(recipeId, output, stripped, input, energy));
        for (int i = 0; i < array.size(); ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            if (!CraftingHelper.processConditions((JsonObject)element, (String)"conditions", (ICondition.IContext)context)) continue;
            boolean stripping = GsonHelper.m_13912_((JsonObject)element, (String)"stripping");
            Lazy<ItemStack> stack = SawmillRecipeSerializer.readOutput(element.get("output"));
            if (stripping) {
                recipe.addToSecondaryStripping(stack);
                continue;
            }
            recipe.addToSecondaryOutput(stack);
        }
        return recipe;
    }

    @Nullable
    public SawmillRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int i;
        Lazy<ItemStack> output = SawmillRecipeSerializer.readLazyStack(buffer);
        Lazy<ItemStack> stripped = SawmillRecipeSerializer.readLazyStack(buffer);
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        SawmillRecipe recipe = new SawmillRecipe(recipeId, output, stripped, input, energy);
        int secondaryCount = buffer.readInt();
        for (i = 0; i < secondaryCount; ++i) {
            recipe.addToSecondaryStripping(SawmillRecipeSerializer.readLazyStack(buffer));
        }
        secondaryCount = buffer.readInt();
        for (i = 0; i < secondaryCount; ++i) {
            recipe.addToSecondaryOutput(SawmillRecipeSerializer.readLazyStack(buffer));
        }
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buffer, SawmillRecipe recipe) {
        SawmillRecipeSerializer.writeLazyStack(buffer, recipe.output);
        buffer.m_130055_((ItemStack)recipe.stripped.get());
        recipe.input.m_43923_(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.secondaryStripping.size());
        for (Lazy secondaryOutput : recipe.secondaryStripping) {
            buffer.m_130055_((ItemStack)secondaryOutput.get());
        }
        buffer.writeInt(recipe.secondaryOutputs.size());
        for (Lazy secondaryOutput : recipe.secondaryOutputs) {
            buffer.m_130055_((ItemStack)secondaryOutput.get());
        }
    }
}

