/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class IEPotions {
    public static final DeferredRegister<MobEffect> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"immersiveengineering");
    public static final RegistryObject<MobEffect> FLAMMABLE = REGISTER.register("flammable", () -> new IEPotion(MobEffectCategory.HARMFUL, 9387807, 0, false, 0, true, true));
    public static final RegistryObject<MobEffect> SLIPPERY = REGISTER.register("slippery", () -> new IEPotion(MobEffectCategory.HARMFUL, 1511427, 0, false, 1, true, true));
    public static final RegistryObject<MobEffect> CONDUCTIVE = REGISTER.register("conductive", () -> new IEPotion(MobEffectCategory.HARMFUL, 0x690000, 0, false, 2, true, true));
    public static final RegistryObject<MobEffect> STICKY = REGISTER.register("sticky", () -> new IEPotion(MobEffectCategory.HARMFUL, 10250240, 0, false, 3, true, true).m_19472_(Attributes.f_22279_, Utils.generateNewUUID().toString(), -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> STUNNED = REGISTER.register("stunned", () -> new IEPotion(MobEffectCategory.HARMFUL, 6441624, 0, false, 4, true, true));
    public static final RegistryObject<MobEffect> CONCRETE_FEET = REGISTER.register("concrete_feet", () -> new IEPotion(MobEffectCategory.HARMFUL, 6441624, 0, false, 5, true, true).m_19472_(Attributes.f_22279_, Utils.generateNewUUID().toString(), -2.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> FLASHED = REGISTER.register("flashed", () -> new IEPotion(MobEffectCategory.HARMFUL, 6441624, 0, false, 6, true, true).m_19472_(Attributes.f_22279_, Utils.generateNewUUID().toString(), -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL));

    static {
        IEApi.potions = ImmutableList.of(FLAMMABLE, SLIPPERY, CONDUCTIVE, STICKY, STUNNED, CONCRETE_FEET, FLASHED);
    }

    public static class IEPotion
    extends MobEffect {
        private static final Set<Block> concrete = ImmutableSet.builder().add((Object)IEBlocks.StoneDecoration.CONCRETE.get()).add((Object)IEBlocks.StoneDecoration.CONCRETE_TILE.get()).add((Object)IEBlocks.StoneDecoration.CONCRETE_SPRAYED.get()).add((Object)IEBlocks.TO_STAIRS.get(IEBlocks.StoneDecoration.CONCRETE.getId()).get()).add((Object)IEBlocks.StoneDecoration.CONCRETE_THREE_QUARTER.get()).add((Object)IEBlocks.StoneDecoration.CONCRETE_SHEET.get()).add((Object)IEBlocks.StoneDecoration.CONCRETE_QUARTER.get()).add((Object)IEBlocks.StoneDecoration.CONCRETE_LEADED.get()).build();
        final int tickrate;
        final boolean halfTickRateWIthAmplifier;
        boolean showInInventory = true;
        boolean showInHud = true;

        public IEPotion(MobEffectCategory isBad, int colour, int tick, boolean halveTick, int icon, boolean showInInventory, boolean showInHud) {
            super(isBad, colour);
            this.showInInventory = showInInventory;
            this.showInHud = showInHud;
            this.tickrate = tick;
            this.halfTickRateWIthAmplifier = halveTick;
        }

        public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
            consumer.accept(new IClientMobEffectExtensions(){

                public boolean isVisibleInGui(MobEffectInstance instance) {
                    return showInHud;
                }

                public boolean isVisibleInInventory(MobEffectInstance instance) {
                    return showInInventory;
                }
            });
        }

        public boolean m_6584_(int duration, int amplifier) {
            if (this.tickrate < 0) {
                return false;
            }
            int k = this.tickrate >> amplifier;
            return k <= 0 || duration % k == 0;
        }

        public void m_6742_(LivingEntity living, int amplifier) {
            BlockState state;
            if (this == SLIPPERY.get()) {
                EquipmentSlot hand;
                if (living.m_20096_()) {
                    living.m_19920_(0.0f, new Vec3(0.0, 1.0, 0.005));
                }
                EquipmentSlot equipmentSlot = hand = living.m_217043_().m_188499_() ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                if (!living.f_19853_.f_46443_ && living.m_217043_().m_188503_(300) == 0 && !living.m_6844_(hand).m_41619_()) {
                    ItemEntity dropped = living.m_5552_(living.m_6844_(hand).m_41777_(), 1.0f);
                    dropped.m_32010_(20);
                    living.m_8061_(hand, ItemStack.f_41583_);
                }
            } else if (this == CONCRETE_FEET.get() && !living.f_19853_.f_46443_ && !concrete.contains((state = living.f_19853_.m_8055_(living.m_20183_())).m_60734_())) {
                if (concrete.stream().map(arg_0 -> ((DefaultedRegistry)Registry.f_122824_).m_7981_(arg_0)).map(IEBlocks.TO_SLAB::get).filter(Objects::nonNull).noneMatch(b -> b.get() == state.m_60734_())) {
                    living.m_21195_((MobEffect)this);
                }
            }
        }
    }
}

