/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionRemoveMultipleOutputs;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.util.Lazy;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Sawmill")
@ZenCodeType.Name(value="mods.immersiveengineering.Sawmill")
public class SawmillRecipeManager
implements IRecipeManager<SawmillRecipe> {
    public RecipeType<SawmillRecipe> getRecipeType() {
        return IERecipeTypes.SAWMILL.get();
    }

    public void remove(IIngredient output) {
        AbstractActionRemoveMultipleOutputs<SawmillRecipe> action = new AbstractActionRemoveMultipleOutputs<SawmillRecipe>((IRecipeManager)this, output){

            @Override
            public List<ItemStack> getAllOutputs(SawmillRecipe recipe) {
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                itemStacks.add((ItemStack)recipe.output.get());
                itemStacks.add((ItemStack)recipe.stripped.get());
                for (Lazy secondaryOutput : recipe.secondaryOutputs) {
                    itemStacks.add((ItemStack)secondaryOutput.get());
                }
                for (Lazy strippingOutput : recipe.secondaryStripping) {
                    itemStacks.add((ItemStack)strippingOutput.get());
                }
                return itemStacks;
            }
        };
        CraftTweakerAPI.apply((IAction)action);
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredient input, int energy, IItemStack strippedOutput, IItemStack[] strippedOutputSecondaries, IItemStack output, IItemStack[] outputSecondaries) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        Ingredient ingredient = input.asVanillaIngredient();
        ItemStack stripped = strippedOutput.getInternal();
        ItemStack[] secondaryStripping = CrTIngredientUtil.getItemStacks(strippedOutputSecondaries);
        if (stripped.m_41619_() && strippedOutputSecondaries.length != 0) {
            throw new IllegalArgumentException("Cannot have secondary stripped outputs when the main stripped output is empty!");
        }
        ItemStack mainOutput = output.getInternal();
        ItemStack[] secondaryOutputs = CrTIngredientUtil.getItemStacks(outputSecondaries);
        SawmillRecipe recipe = IEServerConfig.MACHINES.sawmillConfig.apply(new SawmillRecipe(resourceLocation, IESerializableRecipe.of(mainOutput), IESerializableRecipe.of(stripped), ingredient, energy));
        for (ItemStack stack : secondaryStripping) {
            recipe.addToSecondaryStripping(IESerializableRecipe.of(stack));
        }
        for (ItemStack stack : secondaryOutputs) {
            recipe.addToSecondaryOutput(IESerializableRecipe.of(stack));
        }
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe, null));
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredient input, int energy, IItemStack output, IItemStack[] outputSecondaries) {
        this.addRecipe(recipePath, input, energy, (IItemStack)MCItemStack.EMPTY.get(), new IItemStack[0], output, outputSecondaries);
    }
}

