/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import java.io.File;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.ClientPlatformProxy;

public final class PlatformProxy {
    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        return UsernameCache.getLastKnownUsername((UUID)uuid);
    }

    public static File getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static boolean isShears(ItemStack tool) {
        return tool.m_204117_(Tags.Items.SHEARS);
    }

    public static boolean isShearable(BlockState state) {
        return state.m_60734_() instanceof IForgeShearable;
    }

    public static boolean isCorrectToolForDrops(BlockState state, Player player) {
        return ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
    }

    public static String getModIdFromItem(ItemStack stack) {
        ResourceLocation id;
        String s;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("id") && (s = stack.m_41783_().m_128461_("id")).contains(":") && (id = ResourceLocation.m_135820_((String)s)) != null) {
            return id.m_135827_();
        }
        return stack.m_41720_().getCreatorModId(stack);
    }

    public static boolean isPhysicallyClient() {
        return FMLEnvironment.dist.isClient();
    }

    public static void init() {
        if (PlatformProxy.isPhysicallyClient()) {
            ClientPlatformProxy.init();
        }
    }

    public static List<ViewGroup<ItemStack>> wrapItemStorage(Object target, @Nullable Player player) {
        int size = 54;
        if (target instanceof CapabilityProvider) {
            LazyOptional optional;
            CapabilityProvider capProvider = (CapabilityProvider)target;
            if ((!(target instanceof Entity) || target instanceof AbstractChestedHorse) && (optional = capProvider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
                return List.of((ViewGroup)optional.map($ -> ItemView.fromItemHandler($, size, target instanceof AbstractChestedHorse ? 2 : 0)).get());
            }
        }
        if (target instanceof Container) {
            Container container = (Container)target;
            return List.of(ItemView.fromContainer(container, size, 0));
        }
        if (player != null && target instanceof EnderChestBlockEntity) {
            return List.of(ItemView.fromContainer((Container)player.m_36327_(), size, 0));
        }
        return null;
    }

    public static List<ViewGroup<CompoundTag>> wrapFluidStorage(Object target, @Nullable Player player) {
        CapabilityProvider capProvider;
        IFluidHandler fluidHandler;
        if (target instanceof CapabilityProvider && (fluidHandler = (IFluidHandler)(capProvider = (CapabilityProvider)target).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null)) != null) {
            return FluidView.fromFluidHandler(fluidHandler);
        }
        return null;
    }

    public static List<ViewGroup<CompoundTag>> wrapEnergyStorage(Object target, @Nullable Player player) {
        CapabilityProvider capProvider;
        IEnergyStorage storage;
        if (target instanceof CapabilityProvider && (storage = (IEnergyStorage)(capProvider = (CapabilityProvider)target).getCapability(CapabilityEnergy.ENERGY).orElse(null)) != null && storage.getMaxEnergyStored() > 0) {
            ViewGroup<CompoundTag> group = new ViewGroup<CompoundTag>(List.of(EnergyView.fromForgeEnergy(storage)));
            group.getExtraData().m_128359_("Unit", "FE");
            return List.of(group);
        }
        return null;
    }

    public static boolean isDevEnv() {
        return !FMLEnvironment.production;
    }

    public static float getEnchantPowerBonus(BlockState state, Level world, BlockPos pos) {
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static ResourceLocation getId(Block block) {
        return Registry.f_122824_.m_7981_((Object)block);
    }

    public static ResourceLocation getId(EntityType<?> entityType) {
        return Registry.f_122826_.m_7981_(entityType);
    }

    public static ResourceLocation getId(BlockEntityType<?> blockEntityType) {
        return Registry.f_122830_.m_7981_(blockEntityType);
    }

    public static ResourceLocation getId(PaintingVariant motive) {
        return Registry.f_235728_.m_7981_((Object)motive);
    }

    public static String getPlatformIdentifier() {
        return "forge";
    }

    public static MutableComponent getProfressionName(VillagerProfession profession) {
        ResourceLocation profName = ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession);
        return Component.m_237115_((String)(EntityType.f_20492_.m_20675_() + "." + (String)(!"minecraft".equals(profName.m_135827_()) ? profName.m_135827_() + "." : "") + profName.m_135815_()));
    }
}

