/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.client.overlays;

import com.black_dog20.servertabinfo.Config;
import com.black_dog20.servertabinfo.client.ClientDataManager;
import com.black_dog20.servertabinfo.client.keybinds.Keybinds;
import com.black_dog20.servertabinfo.common.utils.Dimension;
import com.black_dog20.servertabinfo.common.utils.Translations;
import com.black_dog20.servertabinfo.repack.bml.client.DrawingContext;
import com.black_dog20.servertabinfo.repack.bml.client.overlay.GameOverlay;
import com.black_dog20.servertabinfo.repack.bml.client.rows.Row;
import com.black_dog20.servertabinfo.repack.bml.client.rows.RowHelper;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.BlankColumn;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.Column;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.HeadColumn;
import com.black_dog20.servertabinfo.repack.bml.client.rows.columns.ITextComponentColumn;
import com.black_dog20.servertabinfo.repack.bml.utils.dimension.DimensionUtil;
import com.black_dog20.servertabinfo.repack.bml.utils.text.TextComponentBuilder;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class PlayerListOverlay
extends GameOverlay.Pre {
    private static final Ordering<PlayerInfo> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private Minecraft minecraft;
    private Font fontRenderer;
    private ItemRenderer itemRenderer;
    private long lastRenderTime = Util.m_137550_();
    private int ticks = 0;
    private int page = 1;

    public PlayerListOverlay() {
        this.minecraft = Minecraft.m_91087_();
        this.fontRenderer = this.minecraft.f_91062_;
        this.itemRenderer = this.minecraft.m_91291_();
    }

    @Override
    public void onRender(PoseStack matrixStack, int width, int height) {
        if (Keybinds.SHOW.m_90857_()) {
            return;
        }
        int y = 10;
        boolean z = false;
        if (Util.m_137550_() - 2000L > this.lastRenderTime) {
            this.page = 1;
            this.ticks = 1;
        }
        Objects.requireNonNull(this.fontRenderer);
        int itemsPerPage = (int)Math.floor((height - 7 * y) / 9);
        List<Row> rows = this.getRows();
        int maxPages = (int)Math.ceil((double)rows.size() / (double)itemsPerPage);
        if (this.ticks % 300 == 0) {
            this.page = this.page >= maxPages ? 1 : ++this.page;
            this.ticks = 1;
        }
        rows = this.getPagedRows(rows, itemsPerPage);
        int maxWidth = RowHelper.getMaxWidth(rows);
        int x = width / 2 - maxWidth / 2;
        DrawingContext drawingContext = new DrawingContext(matrixStack, width, height, x, y, (float)z, this.fontRenderer, this.itemRenderer);
        y = RowHelper.drawRowsWithBackground(drawingContext, rows);
        this.fontRenderer.m_92763_(matrixStack, Translations.PAGE.get(this.page, maxPages), (float)(width / 2 + 2), (float)(y + 2), -1);
        ++this.ticks;
        this.lastRenderTime = Util.m_137550_();
    }

    @Override
    public boolean doRender(NamedGuiOverlay overlay) {
        if (overlay.id().equals((Object)VanillaGuiOverlay.PLAYER_LIST.id())) {
            Objective scoreboard = this.minecraft.f_91073_.m_6188_().m_83416_(0);
            ClientPacketListener handler = this.minecraft.f_91074_.f_108617_;
            boolean shouldShowTabList = this.minecraft.f_91066_.f_92099_.m_90857_() && (!this.minecraft.m_91090_() || handler.m_105142_().size() > 1 || scoreboard != null);
            return shouldShowTabList && (Boolean)Config.REPLACE_PLAYER_LIST.get() != false;
        }
        return false;
    }

    @Override
    public boolean doesCancelEvent() {
        return true;
    }

    private List<Row> getRows() {
        ClientPacketListener nethandlerplayclient = this.minecraft.f_91074_.f_108617_;
        List list = ENTRY_ORDERING.sortedCopy((Iterable)nethandlerplayclient.m_105142_());
        return list.stream().map(this::buildRow).collect(Collectors.toCollection(LinkedList::new));
    }

    private Row buildRow(PlayerInfo playerInfo) {
        Row.RowBuilder builder = new Row.RowBuilder();
        Scoreboard scoreboard = Optional.ofNullable(this.minecraft.f_91073_).map(ClientLevel::m_6188_).orElse(null);
        return builder.withColumn(HeadColumn.of("head", playerInfo)).withColumn(ITextComponentColumn.of("name", this.getPlayerName(playerInfo))).withColumn(BlankColumn.of("nameSpace", 6)).withColumn(ITextComponentColumn.of("dim", this.getPlayerDim(playerInfo))).withColumn(BlankColumn.of("dimSpace", 3)).withColumn(ITextComponentColumn.of("score", this.getPlayerScore(playerInfo, scoreboard)), this.showScoreObjective(scoreboard)).withColumn(BlankColumn.of("scoreSpace", 3), this.showScoreObjective(scoreboard)).withColumn(ITextComponentColumn.of("ping", this.getPlayerPing(playerInfo), Column.Alignment.RIGHT)).withColumn(BlankColumn.of("pingSpace", 1)).build();
    }

    private Component getPlayerScore(PlayerInfo playerInfo, Scoreboard scoreboard) {
        Objective scoreObjective = Optional.ofNullable(scoreboard).map(s -> s.m_83416_(0)).orElse(null);
        return TextComponentBuilder.of("").with(this.getScore(playerInfo, scoreboard, scoreObjective), this.showPlayerScore(playerInfo, scoreObjective)).format(ChatFormatting.YELLOW).build();
    }

    private Supplier<Boolean> showPlayerScore(PlayerInfo playerInfo, Objective scoreObjective) {
        return () -> scoreObjective != null && GameType.SPECTATOR != playerInfo.m_105325_();
    }

    private int getScore(PlayerInfo playerInfo, Scoreboard scoreboard, Objective scoreObjective) {
        if (scoreObjective != null) {
            Score score = scoreboard.m_83471_(playerInfo.m_105312_().getName(), scoreObjective);
            return score.m_83400_();
        }
        return 0;
    }

    private Supplier<Boolean> showScoreObjective(Scoreboard scoreboard) {
        return () -> scoreboard != null && scoreboard.m_83416_(0) != null;
    }

    private boolean isAllowed() {
        return (Boolean)Config.OP_ONLY_MODE.get() == false || this.minecraft.m_91091_() || Optional.ofNullable(this.minecraft.f_91074_).map(player -> player.m_20310_(1)).orElse(false) != false;
    }

    private List<Row> getPagedRows(List<Row> rows, int itemsPerPage) {
        rows = rows.stream().skip((this.page - 1) * itemsPerPage).limit(itemsPerPage).collect(Collectors.toCollection(LinkedList::new));
        return rows;
    }

    private Component getPlayerName(PlayerInfo playerInfo) {
        return Optional.ofNullable(playerInfo).map(PlayerInfo::m_105342_).orElseGet(() -> PlayerTeam.m_83348_((Team)playerInfo.m_105340_(), (Component)Component.m_237113_((String)playerInfo.m_105312_().getName())));
    }

    private Component getPlayerPing(PlayerInfo playerInfo) {
        return TextComponentBuilder.of(playerInfo.m_105330_()).with(Translations.MS).build();
    }

    private Component getPlayerDim(PlayerInfo playerInfo) {
        ResourceLocation dimName = ClientDataManager.PLAYER_DIMENSIONS.getOrDefault(playerInfo.m_105312_().getId(), null);
        return TextComponentBuilder.of(this.getDimensionName(dimName)).with(this.getDimensionTps(dimName), this::isAllowed).build();
    }

    private Component getDimensionName(ResourceLocation dimensionName) {
        if (dimensionName == null) {
            return Translations.UNKOWN.get();
        }
        if (ClientDataManager.DIMENSION_NAME_CACHE.containsKey(dimensionName)) {
            return ClientDataManager.DIMENSION_NAME_CACHE.get(dimensionName);
        }
        MutableComponent name = DimensionUtil.getFormattedDimensionName(dimensionName, "servertabinfo");
        ClientDataManager.DIMENSION_NAME_CACHE.put(dimensionName, (Component)name);
        return name;
    }

    private Component getDimensionTps(ResourceLocation dimensionName) {
        if (dimensionName == null) {
            return Component.m_237113_((String)"");
        }
        Dimension dimension = ClientDataManager.DIMENSIONS.stream().filter(d -> d.name.equals((Object)dimensionName)).findFirst().orElse(null);
        if (dimension == null) {
            return Component.m_237113_((String)"");
        }
        int tps = dimension.tps;
        ChatFormatting color = ChatFormatting.GREEN;
        if (tps < 20) {
            color = ChatFormatting.YELLOW;
        }
        if (tps <= 10) {
            color = ChatFormatting.RED;
        }
        return TextComponentBuilder.of("(").with(tps).format(color).with(")").build();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PlayerComparator
    implements Comparator<PlayerInfo> {
        PlayerComparator() {
        }

        @Override
        public int compare(PlayerInfo player1, PlayerInfo player2) {
            PlayerTeam scoreplayerteam1 = player1.m_105340_();
            PlayerTeam scoreplayerteam2 = player2.m_105340_();
            return ComparisonChain.start().compareTrueFirst(player1.m_105325_() != GameType.SPECTATOR, player2.m_105325_() != GameType.SPECTATOR).compare((Comparable)((Object)this.getName(scoreplayerteam1)), (Comparable)((Object)this.getName(scoreplayerteam2))).compare((Comparable)((Object)player1.m_105312_().getName()), (Comparable)((Object)player2.m_105312_().getName())).result();
        }

        private String getName(PlayerTeam scorePlayerTeam) {
            return Optional.ofNullable(scorePlayerTeam).map(PlayerTeam::m_5758_).orElse("");
        }
    }
}

