/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.mixins.client;

import com.aizistral.nochatreports.NoChatReports;
import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.core.EncryptionUtil;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.client.multiplayer.chat.ChatTrustLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatListener.class})
public class MixinChatListener {
    @Shadow
    private boolean m_240963_(UUID uuid) {
        throw new IllegalStateException("@Shadow transformation failed. Should never happen.");
    }

    @Inject(method={"evaluateTrustLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEvaluateTrustLevel(PlayerChatMessage playerChatMessage, Component component, PlayerInfo playerInfo, Instant instant, CallbackInfoReturnable<ChatTrustLevel> info) {
        if (this.m_240963_(playerChatMessage.m_241067_().f_240864_())) {
            info.setReturnValue((Object)ChatTrustLevel.SECURE);
        } else {
            ChatTrustLevel evaluate = ChatTrustLevel.m_240455_((PlayerChatMessage)playerChatMessage, (Component)component, (PlayerInfo)playerInfo, (Instant)instant);
            if (evaluate == ChatTrustLevel.BROKEN_CHAIN) {
                info.setReturnValue((Object)evaluate);
                return;
            }
            if (evaluate == ChatTrustLevel.NOT_SECURE && NCRConfig.getClient().hideRedChatIndicators()) {
                info.setReturnValue((Object)ChatTrustLevel.SECURE);
            } else if ((evaluate == ChatTrustLevel.FILTERED || evaluate == ChatTrustLevel.MODIFIED) && NCRConfig.getClient().hideYellowChatIndicators()) {
                info.setReturnValue((Object)ChatTrustLevel.SECURE);
            }
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            NoChatReports.LOGGER.info("Received message: {}, from: {}, signature: {}", (Object)Component.Serializer.m_237122_((Component)playerChatMessage.m_237220_()), (Object)playerChatMessage.m_241067_().f_240864_(), (Object)Base64.getEncoder().encodeToString(playerChatMessage.f_240893_().f_240884_()));
        }
    }

    @ModifyVariable(method={"narrateChatMessage(Lnet/minecraft/network/chat/ChatType$Bound;Lnet/minecraft/network/chat/Component;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private Component decryptNarratedMessage(Component msg) {
        return EncryptionUtil.tryDecrypt(msg).orElse(msg);
    }
}

