/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBoxOfEternalClosure;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;

public class BlockBoxOfEternalClosure
extends BlockWithEntity
implements IBlockRarityProvider {
    public static final String FORGOTTEN_PLAYER = "Forgotten Player";
    private static final int LIGHT_LEVEL = 6;
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final VoxelShape SHAPE_EW = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)6.88f, (double)16.0);
    public static final VoxelShape SHAPE_NS = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.88f, (double)12.0);
    public static ItemStack boxOfEternalClosureFilled;

    public BlockBoxOfEternalClosure(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityBoxOfEternalClosure::new);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockBoxOfEternalClosure.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_BOX_OF_ETERNAL_CLOSURE, (BlockEntityTicker)(level.f_46443_ ? new BlockEntityBoxOfEternalClosure.TickerClient() : new BlockEntityBoxOfEternalClosure.TickerServer()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction rotation = (Direction)state.m_61143_((Property)FACING);
        return rotation == Direction.EAST || rotation == Direction.WEST ? SHAPE_EW : SHAPE_NS;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public static EntityType<?> getSpiritTypeWithFallbackSpirit(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("spiritTag")) {
            if (BlockBoxOfEternalClosure.hasPlayer(itemStack)) {
                return EntityType.f_20501_;
            }
            EntityType<?> spiritType = BlockBoxOfEternalClosure.getSpiritTypeRaw(itemStack.m_41783_());
            if (spiritType == null && itemStack.m_41782_() && itemStack.m_41783_().m_128441_("spiritTag")) {
                return RegistryEntries.ENTITY_VENGEANCE_SPIRIT;
            }
            return spiritType;
        }
        return null;
    }

    @Nullable
    public static EntityType<?> getSpiritTypeRaw(@Nullable CompoundTag tag) {
        return BlockEntityBoxOfEternalClosure.getSpiritType(tag);
    }

    public static void setVengeanceSwarmContent(ItemStack itemStack) {
        CompoundTag tag = new CompoundTag();
        CompoundTag spiritTag = new CompoundTag();
        EntityVengeanceSpiritData spiritData = new EntityVengeanceSpiritData();
        spiritData.setSwarm(true);
        spiritData.setRandomSwarmTier(new Random());
        spiritData.writeNBT(spiritTag);
        tag.m_128365_("spiritTag", (Tag)spiritTag);
        itemStack.m_41751_(tag);
    }

    public static void setPlayerContent(ItemStack itemStack, UUID playerId) {
        CompoundTag tag = new CompoundTag();
        CompoundTag spiritTag = new CompoundTag();
        EntityVengeanceSpiritData spiritData = new EntityVengeanceSpiritData();
        spiritData.setPlayerId(playerId.toString());
        spiritData.setPlayerName(FORGOTTEN_PLAYER);
        tag.m_128359_("playerId", spiritData.getPlayerId());
        tag.m_128359_("playerName", spiritData.getPlayerName());
        spiritData.writeNBT(spiritTag);
        tag.m_128365_("spiritTag", (Tag)spiritTag);
        itemStack.m_41751_(tag);
    }

    public static String getPlayerName(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128425_("playerName", 8)) {
            return itemStack.m_41783_().m_128461_("playerName");
        }
        return "";
    }

    public static String getPlayerId(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128425_("playerId", 8)) {
            return itemStack.m_41783_().m_128461_("playerId");
        }
        return "";
    }

    public static boolean hasPlayer(ItemStack itemStack) {
        return !BlockBoxOfEternalClosure.getPlayerId(itemStack).isEmpty();
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return BlockHelpers.doesBlockHaveSolidTopSurface((LevelReader)worldIn, (BlockPos)pos);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.m_60783_((BlockGetter)worldIn, pos.m_7495_(), Direction.UP)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60783_((BlockGetter)worldIn, currentPos.m_7495_(), Direction.UP)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult blockRayTraceResult) {
        return BlockEntityHelpers.get((BlockGetter)worldIn, (BlockPos)pos, BlockEntityBoxOfEternalClosure.class).map(tile -> {
            if (tile.isClosed()) {
                tile.open();
                return InteractionResult.SUCCESS;
            }
            return super.m_6227_(state, worldIn, pos, player, handIn, blockRayTraceResult);
        }).orElseGet(() -> super.m_6227_(state, worldIn, pos, player, handIn, blockRayTraceResult));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityBoxOfEternalClosure.class).map(tile -> tile.getLidAngle() > 0.0f ? 6 : super.getLightEmission(state, world, pos)).orElse(0);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((ItemLike)this));
        items.add((Object)boxOfEternalClosureFilled);
    }

    @Override
    public Rarity getRarity(ItemStack itemStack) {
        return BlockBoxOfEternalClosure.hasPlayer(itemStack) ? Rarity.RARE : Rarity.UNCOMMON;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos blockPos) {
        BlockEntityBoxOfEternalClosure tile;
        if (world.m_7702_(blockPos) != null && (tile = (BlockEntityBoxOfEternalClosure)world.m_7702_(blockPos)).hasSpirit()) {
            return 15;
        }
        return super.m_6782_(blockState, world, blockPos);
    }
}

