/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.core.block.BlockWithEntityGuiTank;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;

public class BlockSpiritFurnace
extends BlockWithEntityGuiTank
implements CubeDetector.IDetectionListener {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public BlockSpiritFurnace(BlockBehaviour.Properties properties) {
        super(properties, BlockEntitySpiritFurnace::new);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockSpiritFurnace.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_SPIRIT_FURNACE, (BlockEntityTicker)(level.f_46443_ ? new BlockEntityTickingTankInventory.TickerClient() : new BlockEntityWorking.TickerServer()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (!BlockEntitySpiritFurnace.canWork(world, blockPos)) {
            return InteractionResult.FAIL;
        }
        return super.m_6227_(blockState, world, blockPos, player, hand, rayTraceResult);
    }

    private void triggerDetector(LevelAccessor world, BlockPos blockPos, boolean valid) {
        BlockEntitySpiritFurnace.getCubeDetector().detect((LevelReader)world, blockPos, valid ? null : blockPos, true);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        this.triggerDetector((LevelAccessor)world, pos, true);
    }

    public void m_6807_(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.m_6807_(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.m_60734_() != blockStateOld.m_60734_() && !((Boolean)blockStateNew.m_61143_((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector((LevelAccessor)world, blockPos, true);
        }
    }

    public void m_6786_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        super.m_6786_(worldIn, pos, state);
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector(worldIn, pos, false);
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (((Boolean)world.m_8055_(pos).m_61143_((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector((LevelAccessor)world, pos, false);
        }
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        this.m_7592_(world, pos, explosion);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.m_8055_(location).m_60734_();
        if (block == this) {
            boolean change = (Boolean)world.m_8055_(location).m_61143_((Property)ACTIVE) == false;
            ((Level)world).m_7731_(location, (BlockState)world.m_8055_(location).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            BlockEntity tile = world.m_7702_(location);
            if (tile != null) {
                ((BlockEntitySpiritFurnace)tile).setSize(valid ? size : Vec3i.f_123288_);
            }
            if (change) {
                BlockEntitySpiritFurnace.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }
}

