/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDisplayStand;

public class BlockEntityDisplayStand
extends CyclopsBlockEntity {
    @NBTPersist
    private ItemStack displayStandType;
    @NBTPersist
    private boolean directionPositive = false;
    private final SimpleInventory inventory = new SimpleInventory(1, 1);

    public BlockEntityDisplayStand(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_DISPLAY_STAND, blockPos, blockState);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> ((SimpleInventory)this.inventory).getItemHandler()));
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void onDirty() {
        super.onDirty();
        this.sendUpdate();
    }

    public Direction.AxisDirection getDirection() {
        return this.directionPositive ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    public void setDirection(Direction.AxisDirection direction) {
        this.directionPositive = direction == Direction.AxisDirection.POSITIVE;
        this.sendUpdate();
    }

    public void setDisplayStandType(ItemStack displayStandType) {
        this.displayStandType = displayStandType;
        this.sendUpdate();
    }

    public ItemStack getDisplayStandType() {
        return this.displayStandType;
    }

    protected Direction getFacing() {
        return (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.m_58904_().m_8055_(this.m_58899_()), (Property)BlockDisplayStand.FACING, (Comparable)Direction.NORTH);
    }

    protected ItemStack getContents() {
        return this.inventory.m_8020_(0);
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.inventory.readFromNBT(tag, "inventory");
    }

    public void m_183515_(CompoundTag tag) {
        this.inventory.writeToNBT(tag, "inventory");
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            capability = CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }
        return facing == this.getFacing() || facing == this.getFacing().m_122424_() || this.getContents().m_41619_() ? super.getCapability(capability, facing) : this.getContents().getCapability(capability, null);
    }

    public void onUpdateReceived() {
        super.onUpdateReceived();
        BlockHelpers.markForUpdate((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }
}

