/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.blockentity.BlockEntityEnvironmentalAccumulator;
import org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.VirtualTank;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;

public class BlockEntitySanguinaryEnvironmentalAccumulator
extends BlockEntityWorking<BlockEntitySanguinaryEnvironmentalAccumulator, MutableInt>
implements VirtualTank.ITankProvider,
MenuProvider {
    public static final int SLOTS = 2;
    public static final int SLOT_ACCUMULATE = 0;
    public static final int SLOT_ACCUMULATE_RESULT = 1;
    public static Metadata METADATA = new Metadata();
    private static final int TANK_CHECK_TICK_OFFSET = 60;
    private int accumulateTicker;
    private SingleCache<Triple<ItemStack, FluidStack, WeatherType>, Optional<RecipeEnvironmentalAccumulator>> recipeCache;
    private VirtualTank virtualTank;
    private boolean forceLoadTanks;
    private List<BlockPos> invalidLocations = Lists.newArrayList();
    private static final Map<Class<?>, ITickAction<BlockEntitySanguinaryEnvironmentalAccumulator>> ACCUMULATE_TICK_ACTIONS = new LinkedHashMap();
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private static final BlockPos[] tankOffsets;

    public BlockEntitySanguinaryEnvironmentalAccumulator(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR, blockPos, blockState, 2, 64, 0, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.accumulateTicker = this.addTicker(new TickComponent<BlockEntitySanguinaryEnvironmentalAccumulator, ITickAction<BlockEntitySanguinaryEnvironmentalAccumulator>>(this, ACCUMULATE_TICK_ACTIONS, 0));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<BlockEntitySanguinaryEnvironmentalAccumulator, MutableInt>(2.0){

            @Override
            public void applyUpgrade(BlockEntitySanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<BlockEntitySanguinaryEnvironmentalAccumulator, MutableInt>(1.0){

            @Override
            public void applyUpgrade(BlockEntitySanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Triple<ItemStack, FluidStack, WeatherType>, Optional<RecipeEnvironmentalAccumulator>>(){

            public Optional<RecipeEnvironmentalAccumulator> getNewValue(Triple<ItemStack, FluidStack, WeatherType> key) {
                Inventory recipeInput = new Inventory(1, 64, BlockEntitySanguinaryEnvironmentalAccumulator.this);
                recipeInput.m_6836_(0, (ItemStack)key.getLeft());
                return CraftingHelpers.findServerRecipe(BlockEntitySanguinaryEnvironmentalAccumulator.this.getRegistry(), (Container)recipeInput, (Level)BlockEntitySanguinaryEnvironmentalAccumulator.this.m_58904_());
            }

            public boolean isKeyEqual(Triple<ItemStack, FluidStack, WeatherType> cacheKey, Triple<ItemStack, FluidStack, WeatherType> newKey) {
                return cacheKey == null || newKey == null || ItemStack.m_41728_((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getMiddle()), (FluidStack)((FluidStack)newKey.getMiddle())) && cacheKey.getRight() == newKey.getRight();
            }
        });
        this.virtualTank = new VirtualTank(this, true);
        this.forceLoadTanks = true;
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerAccumulate = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0}));
        LazyOptional itemHandlerAccumulateResult = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{1}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerAccumulate);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerAccumulateResult);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerAccumulate);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerAccumulate);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerAccumulate);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerAccumulate);
    }

    @Override
    protected void addFluidHandlerCapabilities() {
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new Inventory(inventorySize, stackSize, this){

            @Override
            public boolean m_7013_(int slot, ItemStack itemStack) {
                if (slot == 0) {
                    return BlockEntitySanguinaryEnvironmentalAccumulator.this.getTileWorkingMetadata().canConsume(itemStack, this.getWorld());
                }
                return super.m_7013_(slot, itemStack);
            }
        };
    }

    @Override
    public Inventory getInventory() {
        return (Inventory)super.getInventory();
    }

    public Optional<RecipeEnvironmentalAccumulator> getRecipe(ItemStack itemStack) {
        return (Optional)this.recipeCache.get((Object)new ImmutableTriple((Object)(itemStack.m_41619_() ? ItemStack.f_41583_ : itemStack.m_41777_()), (Object)this.getTank().getFluid().copy(), (Object)WeatherType.getActiveWeather(this.f_58857_)));
    }

    protected RecipeType<RecipeEnvironmentalAccumulator> getRegistry() {
        return RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showAccumulatingParticles() {
        BlockEntityEnvironmentalAccumulator.showAccumulatingParticles(this.f_58857_, (float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_() + 0.5f, (float)this.m_58899_().m_123343_() + 0.5f, 25.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showTankBeams() {
        RandomSource random = this.f_58857_.f_46441_;
        BlockPos target = this.m_58899_();
        for (int j = 0; j < tankOffsets.length; ++j) {
            BlockPos offset = tankOffsets[j];
            BlockPos location = target.m_121955_((Vec3i)offset);
            double x = (double)location.m_123341_() + 0.5;
            double y = (double)location.m_123342_() + 0.5;
            double z = (double)location.m_123343_() + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw((BlockPos)location, (BlockPos)target);
            float rotationPitch = (float)LocationHelpers.getPitch((BlockPos)location, (BlockPos)target);
            for (int i = 0; i < 1 + random.m_188503_(5); ++i) {
                double particleX = x - 0.2 + random.m_188500_() * 0.4;
                double particleY = y - 0.2 + random.m_188500_() * 0.4;
                double particleZ = z - 0.2 + random.m_188500_() * 0.4;
                double speed = 0.5;
                double particleMotionX = (double)(Mth.m_14031_((float)(rotationPitch / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)Mth.m_14089_((float)(rotationPitch / 180.0f * (float)Math.PI)) * -speed;
                double particleMotionZ = (double)(Mth.m_14031_((float)(rotationPitch / 180.0f * (float)Math.PI)) * Mth.m_14031_((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)RegistryEntries.PARTICLE_BLOOD_BUBBLE, false, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showMissingTanks() {
        if (this.f_58857_.m_46467_() % 10L == 0L) {
            RandomSource random = this.f_58857_.f_46441_;
            for (BlockPos location : this.invalidLocations) {
                double x = (double)location.m_123341_() + 0.5;
                double y = (double)location.m_123342_() + 0.5;
                double z = (double)location.m_123343_() + 0.5;
                for (int i = 0; i < 1 + random.m_188503_(5); ++i) {
                    double particleX = x - 0.2 + random.m_188500_() * 0.4;
                    double particleY = y - 0.2 + random.m_188500_() * 0.4;
                    double particleZ = z - 0.2 + random.m_188500_() * 0.4;
                    Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)ParticleTypes.f_123762_, false, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void onStateChanged() {
        BlockState blockState = (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)BlockSanguinaryEnvironmentalAccumulator.ON, (Comparable)Boolean.valueOf(this.isWorking()));
        this.f_58857_.m_46597_(this.m_58899_(), blockState);
        this.f_58857_.m_7260_(this.m_58899_(), blockState, blockState, 3);
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        if (!this.forceLoadTanks && this.invalidLocations != null && !WorldHelpers.efficientTick((Level)this.f_58857_, (int)60, (BlockPos)this.m_58899_())) {
            return this.invalidLocations.isEmpty();
        }
        this.forceLoadTanks = false;
        return this.getVirtualTankChildren() != null;
    }

    @Override
    protected int getWorkTicker() {
        return this.accumulateTicker;
    }

    public VirtualTank getVirtualTank() {
        return this.virtualTank;
    }

    @Override
    @Nullable
    public IFluidHandler[] getVirtualTankChildren() {
        IFluidHandler[] tanks = new IFluidHandler[tankOffsets.length];
        this.invalidLocations.clear();
        for (int i = 0; i < tankOffsets.length; ++i) {
            BlockPos offset = tankOffsets[i];
            BlockPos location = this.m_58899_().m_121955_((Vec3i)offset);
            IFluidHandler handler = (IFluidHandler)BlockEntityHelpers.getCapability((BlockGetter)this.m_58904_(), (BlockPos)location, (Direction)Direction.UP, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
            boolean oneValid = false;
            if (handler != null) {
                int tankAmount = handler.getTanks();
                for (int tank = 0; tank < tankAmount; ++tank) {
                    if (handler.getFluidInTank(tank).isEmpty() || handler.getFluidInTank(tank).getFluid() != RegistryEntries.FLUID_BLOOD) continue;
                    oneValid = true;
                    break;
                }
            }
            if (!oneValid) {
                this.invalidLocations.add(location);
            }
            tanks[i] = handler;
        }
        if (!this.invalidLocations.isEmpty()) {
            return null;
        }
        return tanks;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, net.minecraft.world.entity.player.Inventory playerInventory, Player playerEntity) {
        return new ContainerSanguinaryEnvironmentalAccumulator(id, playerInventory, this.getInventory(), Optional.of(this));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.evilcraft.sanguinary_environmental_accumulator");
    }

    public List<BlockPos> getInvalidLocations() {
        return this.invalidLocations;
    }

    static {
        ACCUMULATE_TICK_ACTIONS.put(Item.class, new AccumulateItemTickAction());
        TICKERS = 1;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        tankOffsets = new BlockPos[]{new BlockPos(-3, 0, -1), new BlockPos(-3, 0, 1), new BlockPos(3, 0, -1), new BlockPos(3, 0, 1), new BlockPos(-1, 0, -3), new BlockPos(-1, 0, 3), new BlockPos(1, 0, -3), new BlockPos(1, 0, 3)};
    }

    public static class Inventory
    extends BlockEntityWorking.Inventory<BlockEntitySanguinaryEnvironmentalAccumulator>
    implements RecipeEnvironmentalAccumulator.Inventory {
        public Inventory(int size, int stackLimit, BlockEntitySanguinaryEnvironmentalAccumulator tile) {
            super(size, stackLimit, tile);
        }

        @Override
        public Level getWorld() {
            return ((BlockEntitySanguinaryEnvironmentalAccumulator)this.tile).m_58904_();
        }

        @Override
        public BlockPos getPos() {
            return ((BlockEntitySanguinaryEnvironmentalAccumulator)this.tile).m_58899_();
        }
    }

    public static class Metadata
    extends BlockEntityWorking.Metadata {
        private Metadata() {
            super(2);
        }

        @Override
        public boolean canInsertItem(Container inventory, int slot, ItemStack itemStack) {
            return slot != this.getProduceSlot() && super.canInsertItem(inventory, slot, itemStack);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, Level world) {
            RecipeEnvironmentalAccumulator.InventoryDummy recipeInput = new RecipeEnvironmentalAccumulator.InventoryDummy(itemStack);
            return world.m_7465_().m_44015_(RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR, (Container)recipeInput, world).isPresent();
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR;
        }

        public int getConsumeSlot() {
            return 0;
        }

        public int getProduceSlot() {
            return 1;
        }
    }

    public static class TickerClient
    extends BlockEntityTickingTankInventory.TickerClient<BlockEntitySanguinaryEnvironmentalAccumulator> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySanguinaryEnvironmentalAccumulator blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (blockEntity.isVisuallyWorking()) {
                blockEntity.showTankBeams();
                if (blockEntity.getRequiredWorkTicks() - (float)blockEntity.getWorkTick() > 50.0f) {
                    blockEntity.showAccumulatingParticles();
                }
            } else if (!blockEntity.canWork()) {
                blockEntity.showMissingTanks();
            }
        }
    }
}

