/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.purifier;

import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.blockentity.tickaction.bloodchest.DamageableItemRepairAction;
import org.cyclops.evilcraft.enchantment.EnchantmentVengeance;
import org.cyclops.evilcraft.item.ItemVengeancePickaxe;

public class ToolBadEnchantPurifyAction
implements IPurifierAction {
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canWork(BlockEntityPurifier tile) {
        if (!tile.getPurifyItem().m_41619_() && tile.getBucketsFloored() > 0) {
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)tile.getPurifyItem()).entrySet()) {
                if (!((Enchantment)entry.getKey()).m_6589_()) continue;
                return true;
            }
            for (Enchantment enchant : DamageableItemRepairAction.BAD_ENCHANTS) {
                int enchantmentListID;
                if (tile.getPurifyItem().m_41720_() instanceof ItemVengeancePickaxe && !(enchant instanceof EnchantmentVengeance) || (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)tile.getPurifyItem(), (Enchantment)enchant)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean removeEnchant(Level world, BlockEntityPurifier tile, ItemStack purifyItem, int tick, Enchantment enchant) {
        int enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)purifyItem, (Enchantment)enchant);
        if (enchantmentListID > -1) {
            if (tick >= 60) {
                if (!world.m_5776_()) {
                    int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)purifyItem, (int)enchantmentListID);
                    EnchantmentHelpers.setEnchantmentLevel((ItemStack)purifyItem, (int)enchantmentListID, (int)(level - 1));
                }
                tile.setBuckets(tile.getBucketsFloored() - 1, tile.getBucketsRest());
                return true;
            }
            if (world.m_5776_()) {
                tile.showEffect();
            }
        }
        return false;
    }

    @Override
    public boolean work(BlockEntityPurifier tile) {
        boolean done = false;
        ItemStack purifyItem = tile.getPurifyItem();
        Level world = tile.m_58904_();
        int tick = tile.getTick();
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)tile.getPurifyItem()).entrySet()) {
            if (done || !((Enchantment)entry.getKey()).m_6589_()) continue;
            done = this.removeEnchant(world, tile, purifyItem, tick, (Enchantment)entry.getKey());
        }
        for (Enchantment enchant : DamageableItemRepairAction.BAD_ENCHANTS) {
            if (done || tile.getPurifyItem().m_41720_() instanceof ItemVengeancePickaxe && !(enchant instanceof EnchantmentVengeance)) continue;
            done = this.removeEnchant(world, tile, purifyItem, tick, enchant);
        }
        return done;
    }
}

