/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.block.BlockSanguinaryEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.blockentity.BlockEntitySanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;

public class AccumulateItemTickAction
implements ITickAction<BlockEntitySanguinaryEnvironmentalAccumulator> {
    @Override
    public boolean canTick(BlockEntitySanguinaryEnvironmentalAccumulator tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.getInventory().m_8020_(0).m_41619_() && tile.getTileWorkingMetadata().canConsume(tile.getInventory().m_8020_(0), tile.m_58904_())) {
            ItemStack production = tile.getInventory().m_8020_(tile.getTileWorkingMetadata().getProduceSlot());
            return this.getRecipe(tile).map(recipe -> {
                boolean precondition = false;
                ItemStack willProduce = this.willProduceItem(tile, (RecipeEnvironmentalAccumulator)recipe);
                if (production.m_41619_()) {
                    precondition = true;
                } else if (!willProduce.m_41619_() && production.m_41720_() == this.willProduceItem(tile, (RecipeEnvironmentalAccumulator)recipe).m_41720_() && Objects.equals(production.m_41783_(), this.willProduceItem(tile, (RecipeEnvironmentalAccumulator)recipe).m_41783_()) && production.m_41613_() + willProduce.m_41613_() <= production.m_41741_()) {
                    precondition = true;
                }
                return precondition && tile.canWork() && tile.getVirtualTank().getFluidAmount() >= this.getRequiredFluidAmount(tile, (RecipeEnvironmentalAccumulator)recipe);
            }).orElse(false);
        }
        return false;
    }

    @Override
    public void onTick(BlockEntitySanguinaryEnvironmentalAccumulator tile, ItemStack itemStack, int slot, int tick) {
        RecipeEnvironmentalAccumulator recipe;
        ItemStack result;
        Optional<RecipeEnvironmentalAccumulator> optionalRecipe = this.getRecipe(tile);
        if (optionalRecipe.isPresent() && tick >= this.getRequiredTicks(tile, optionalRecipe.get()) && this.addToProduceSlot(tile, result = (recipe = optionalRecipe.get()).assemble(tile.getInventory()))) {
            tile.getInventory().m_7407_(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            tile.getVirtualTank().drain(this.getRequiredFluidAmount(tile, recipe), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public final float getRequiredTicks(BlockEntitySanguinaryEnvironmentalAccumulator tile, int slot, int tick) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(this.getRecipe(tile).get()));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntitySanguinaryEnvironmentalAccumulator.UPGRADEEVENT_SPEED));
        return duration.getValue().intValue();
    }

    public static int getUsage(int baseCooldownTime) {
        return baseCooldownTime * BlockSanguinaryEnvironmentalAccumulatorConfig.baseUsage;
    }

    protected int getRequiredFluidAmount(BlockEntitySanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        MutableInt amount = new MutableInt(AccumulateItemTickAction.getUsage(recipe.getCooldownTime()));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, BlockEntitySanguinaryEnvironmentalAccumulator.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private Optional<RecipeEnvironmentalAccumulator> getRecipe(BlockEntitySanguinaryEnvironmentalAccumulator tile) {
        return tile.getRecipe(tile.getInventory().m_8020_(0));
    }

    private int getUnmodifiedRequiredTicks(RecipeEnvironmentalAccumulator recipe) {
        return recipe.getDuration();
    }

    private int getRequiredTicks(BlockEntitySanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntitySanguinaryEnvironmentalAccumulator.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    protected ItemStack willProduceItem(BlockEntitySanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        return recipe.assemble(tile.getInventory());
    }

    public boolean addToProduceSlot(BlockEntitySanguinaryEnvironmentalAccumulator tile, ItemStack itemStack) {
        return InventoryHelpers.addToSlot((Container)tile.getInventory(), (int)tile.getTileWorkingMetadata().getProduceSlot(), (ItemStack)itemStack);
    }
}

