/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.blockentity.BlockEntityDisplayStand;

public class RenderBlockEntityDisplayStand
implements BlockEntityRenderer<BlockEntityDisplayStand> {
    private static final Map<Direction, Vector3f> ROTATIONS = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)new Vector3f(270.0f, 0.0f, 0.0f)).put((Object)Direction.SOUTH, (Object)new Vector3f(90.0f, 0.0f, 0.0f)).put((Object)Direction.WEST, (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Direction.EAST, (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Direction.UP, (Object)new Vector3f(180.0f, 180.0f, 0.0f)).put((Object)Direction.DOWN, (Object)new Vector3f(0.0f, 0.0f, 0.0f)).build();

    public RenderBlockEntityDisplayStand(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityDisplayStand tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getInventory().m_8020_(0).m_41619_()) {
            BlockState blockState = tile.m_58904_().m_8055_(tile.m_58899_());
            this.renderItem(matrixStackIn, bufferIn, tile.getInventory().m_8020_(0), (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)BlockDisplayStand.FACING, (Comparable)Direction.NORTH), (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)BlockDisplayStand.AXIS_X, (Comparable)Boolean.valueOf(true)), tile.getDirection() == Direction.AxisDirection.POSITIVE);
        }
    }

    private void renderItem(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, ItemStack itemStack, Direction facing, boolean axisX, boolean positiveDirection) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        if (itemStack.m_41720_() instanceof BlockItem) {
            matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        } else if (itemStack.m_41720_() instanceof IBroom) {
            matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        } else if (!(itemStack.m_41720_() instanceof IBroom)) {
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStack.m_85837_(0.0, 0.25, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        }
        Vector3f vec = ROTATIONS.get(facing);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(vec.m_122239_()));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(vec.m_122260_()));
        if (!axisX) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            if (!positiveDirection) {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
        } else if (positiveDirection) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        Minecraft.m_91087_().m_91291_().m_174269_(itemStack, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStack, renderTypeBuffer, 0);
        matrixStack.m_85849_();
    }
}

