/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritPortal;

public class RenderBlockEntitySpiritPortal
implements BlockEntityRenderer<BlockEntitySpiritPortal> {
    private static final ResourceLocation PORTALBASE = new ResourceLocation("evilcraft", "textures/model/portal_bases.png");

    public RenderBlockEntitySpiritPortal(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntitySpiritPortal tileentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float progress = tileentity.getProgress();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        this.renderPortalBase(matrixStackIn, bufferIn, progress);
        Random random = new Random();
        long seed = tileentity.m_58899_().m_121878_();
        random.setSeed(seed);
        this.renderStar(matrixStackIn, bufferIn, seed, progress, Tesselator.m_85913_(), partialTicks, random);
        matrixStackIn.m_85849_();
    }

    private void renderStar(PoseStack matrixStackIn, MultiBufferSource bufferIn, float rotation, float progress, Tesselator tessellator, float partialTicks, Random random) {
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(rotation * -0.2f % 360.0f / 2.0f));
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(rotation * -0.2f % 360.0f));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(rotation * -0.2f % 360.0f / 2.0f));
        float BEAM_START_DISTANCE = 2.0f;
        float BEAM_END_DISTANCE = 7.0f;
        float MAX_OPACITY = 40.0f;
        float f2 = 0.0f;
        if (progress > 0.8f) {
            f2 = (progress - 0.8f) / 0.2f;
        }
        int i = 0;
        while ((float)i < (progress + progress * progress) / 2.0f * 60.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f));
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f + progress * 90.0f));
            float f3 = random.nextFloat() * BEAM_END_DISTANCE + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * BEAM_START_DISTANCE + 1.0f + f2 * 2.0f;
            VertexConsumer vb = bufferIn.m_6299_(RenderType.m_110502_());
            Matrix4f matrix = matrixStackIn.m_85850_().m_85861_();
            vb.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(171, 97, 210, (int)(MAX_OPACITY * (1.0f - f2))).m_5752_();
            vb.m_85982_(matrix, -0.866f * f4, f3, -0.5f * f4).m_6122_(175, 100, 215, 0).m_5752_();
            vb.m_85982_(matrix, 0.866f * f4, f3, -0.5f * f4).m_6122_(175, 100, 215, 0).m_5752_();
            vb.m_85982_(matrix, 0.0f, f3, 1.0f * f4).m_6122_(175, 100, 215, 0).m_5752_();
            vb.m_85982_(matrix, -0.866f * f4, f3, -0.5f * f4).m_6122_(175, 100, 215, 0).m_5752_();
            ++i;
        }
    }

    private void renderPortalBase(PoseStack matrixStackIn, MultiBufferSource bufferIn, float progress) {
        matrixStackIn.m_85836_();
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        matrixStackIn.m_85845_(renderManager.m_114470_());
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        this.renderIconForProgress(matrixStackIn, bufferIn, (int)(progress * 100.0f) % 4, progress);
        matrixStackIn.m_85849_();
    }

    private void renderIconForProgress(PoseStack matrixStackIn, MultiBufferSource bufferIn, int index, float progress) {
        if (progress > 0.8f) {
            progress -= (progress - 0.8f) * 4.0f;
        }
        float u1 = 0.0625f * (float)index;
        float u2 = 0.0625f * (float)(index + 1);
        float v1 = 0.0f;
        float v2 = 0.0625f;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(0.5f * progress, 0.5f * progress, 0.5f * progress);
        matrixStackIn.m_85837_(-0.5, -0.5, 0.0);
        int j = 150;
        int k = 150;
        VertexConsumer vb = bufferIn.m_6299_(RenderType.m_110497_((ResourceLocation)PORTALBASE));
        Matrix4f matrix = matrixStackIn.m_85850_().m_85861_();
        vb.m_85982_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(0.72f, 0.5f, 0.23f, 0.9f).m_7421_(u1, v2).m_7120_(j, k).m_5752_();
        vb.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(0.72f, 0.5f, 0.83f, 0.9f).m_7421_(u1, v1).m_7120_(j, k).m_5752_();
        vb.m_85982_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(0.72f, 0.5f, 0.83f, 0.9f).m_7421_(u2, v1).m_7120_(j, k).m_5752_();
        vb.m_85982_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(0.72f, 0.5f, 0.83f, 0.9f).m_7421_(u2, v2).m_7120_(j, k).m_5752_();
        matrixStackIn.m_85849_();
    }
}

