/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;

public class RenderVengeanceSpirit
extends EntityRenderer<EntityVengeanceSpirit> {
    private final RenderPlayerSpirit playerRenderer;
    private final Map<GameProfile, GameProfile> checkedProfiles = Maps.newHashMap();

    public RenderVengeanceSpirit(EntityRendererProvider.Context context, EntityVengeanceSpiritConfig config) {
        super(context);
        this.playerRenderer = new RenderPlayerSpirit(context);
    }

    public void render(EntityVengeanceSpirit spirit, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        EntityRenderer render;
        super.m_7392_((Entity)spirit, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        Mob innerEntity = spirit.getInnerEntity();
        if (innerEntity != null && spirit.isVisible() && (render = (EntityRenderer)this.f_114476_.f_114362_.get(innerEntity.m_6095_())) != null && !spirit.isSwarm()) {
            MultiBufferSource bufferSub = renderType -> {
                float uv = spirit.isFrozen() ? ((float)spirit.f_19797_ + partialTicks) * 0.01f : 1.0f;
                renderType = RenderType.m_110436_((ResourceLocation)(spirit.isPlayer() ? this.playerRenderer : render).m_5478_((Entity)innerEntity), (float)uv, (float)uv);
                return bufferIn.m_6299_(renderType);
            };
            try {
                if (spirit.isPlayer()) {
                    GameProfile gameProfile = new GameProfile(spirit.getPlayerUUID(), spirit.getPlayerName());
                    ResourceLocation resourcelocation = DefaultPlayerSkin.m_118626_();
                    Minecraft minecraft = Minecraft.m_91087_();
                    if (!this.checkedProfiles.containsKey(gameProfile)) {
                        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                        if (property == null) {
                            GameProfile newGameProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(gameProfile, true);
                            this.checkedProfiles.put(gameProfile, newGameProfile);
                        }
                    } else {
                        Map map = minecraft.m_91109_().m_118815_(this.checkedProfiles.get(gameProfile));
                        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            resourcelocation = minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                        }
                    }
                    this.playerRenderer.setPlayerTexture(resourcelocation);
                    this.playerRenderer.m_7392_((LivingEntity)innerEntity, entityYaw, partialTicks, matrixStackIn, bufferSub, packedLightIn);
                } else {
                    matrixStackIn.m_85836_();
                    render.m_7392_((Entity)innerEntity, entityYaw, 0.0f, matrixStackIn, bufferSub, packedLightIn);
                    matrixStackIn.m_85849_();
                }
            }
            catch (Exception e) {
                spirit.setSwarm(true);
                spirit.setPlayerId("");
            }
        }
    }

    public ResourceLocation getTextureLocation(EntityVengeanceSpirit entity) {
        return null;
    }

    public static class RenderPlayerSpirit
    extends LivingEntityRenderer<Mob, PlayerModel<Mob>> {
        private ResourceLocation playerTexture;

        public RenderPlayerSpirit(EntityRendererProvider.Context context) {
            super(context, (EntityModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
            this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_))));
            this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
            this.m_115326_((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
            this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        }

        public ResourceLocation getTextureLocation(Mob entity) {
            return this.playerTexture;
        }

        public void setPlayerTexture(ResourceLocation playerTexture) {
            this.playerTexture = playerTexture;
        }
    }
}

