/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class BlockEntityTankInventory
extends CyclopsBlockEntity {
    private final SimpleInventory inventory;
    private final SingleUseTank tank;
    protected final int tankSize;

    public BlockEntityTankInventory(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize, int stackSize, int tankSize, @Nullable Fluid acceptedFluid) {
        super(type, blockPos, blockState);
        this.inventory = this.createInventory(inventorySize, stackSize);
        this.tank = this.createTank(tankSize);
        this.tankSize = tankSize;
        if (acceptedFluid != null) {
            this.tank.setAcceptedFluid(acceptedFluid);
        }
        this.addItemHandlerCapabilities();
        this.addFluidHandlerCapabilities();
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.tank.addDirtyMarkListener(this::onTankChanged);
    }

    protected void addItemHandlerCapabilities() {
        for (Direction side : Direction.values()) {
            this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> this.inventory.getItemHandlerSided(side)));
        }
    }

    protected void addFluidHandlerCapabilities() {
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(() -> this.tank));
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize);
    }

    protected SingleUseTank createTank(int tankSize) {
        return new SingleUseTank(tankSize);
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.inventory.readFromNBT(tag, "inventory");
        this.tank.readFromNBT(tag, "tank");
    }

    public void m_183515_(CompoundTag tag) {
        this.inventory.writeToNBT(tag, "inventory");
        this.tank.writeToNBT(tag, "tank");
        super.m_183515_(tag);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void onTankChanged() {
        this.m_6596_();
        this.getInventory().m_6596_();
    }
}

