/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;

public abstract class BlockEntityTickingTankInventory<T extends BlockEntityTankInventory>
extends BlockEntityTankInventory {
    private List<TickComponent<T, ITickAction<T>>> tickers = Lists.newArrayList();
    protected int currentState = -1;
    protected int previousState = -1;

    public BlockEntityTickingTankInventory(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize, int stackSize, int tankSize, Fluid acceptedFluid) {
        super(type, blockPos, blockState, inventorySize, stackSize, tankSize, acceptedFluid);
    }

    protected int addTicker(TickComponent<T, ITickAction<T>> ticker) {
        this.tickers.add(ticker);
        return this.tickers.size() - 1;
    }

    public List<TickComponent<T, ITickAction<T>>> getTickers() {
        return this.tickers;
    }

    @Override
    public void read(CompoundTag data) {
        super.read(data);
        this.currentState = data.m_128451_("currentState");
        ListTag tickerList = data.m_128437_("tickers", 10);
        for (int i = 0; i < this.tickers.size(); ++i) {
            TickComponent<T, ITickAction<T>> ticker = this.tickers.get(i);
            if (tickerList.size() <= i) continue;
            CompoundTag tag = tickerList.m_128728_(i);
            ticker.setTick(tag.m_128451_("tick"));
            ticker.setRequiredTicks(tag.m_128457_("requiredTicks"));
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128405_("currentState", this.currentState);
        ListTag tickerList = new ListTag();
        for (TickComponent<T, ITickAction<T>> ticker : this.tickers) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("tick", ticker.getTick());
            tag.m_128350_("requiredTicks", ticker.getRequiredTicks());
            tickerList.add((Object)tag);
        }
        data.m_128365_("tickers", (Tag)tickerList);
    }

    protected boolean hasJustWorked() {
        return false;
    }

    public abstract int getNewState();

    public abstract void onStateChanged();

    public int getCurrentState() {
        return this.currentState;
    }

    public static class TickerClient<T extends BlockEntityTickingTankInventory<T>>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityTickingTankInventory)((Object)blockEntity)).previousState != ((BlockEntityTickingTankInventory)((Object)blockEntity)).currentState) {
                ((BlockEntityTickingTankInventory)((Object)blockEntity)).previousState = ((BlockEntityTickingTankInventory)((Object)blockEntity)).currentState;
                ((BlockEntityTickingTankInventory)((Object)blockEntity)).onStateChanged();
            }
        }
    }

    public static class TickerServer<T extends BlockEntityTickingTankInventory<T>>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            boolean redstone = level.m_46753_(pos);
            for (TickComponent ticker : ((BlockEntityTickingTankInventory)((Object)blockEntity)).getTickers()) {
                if (ticker.isRedstoneDisableable() && redstone) continue;
                ticker.tick(((BlockEntityTankInventory)((Object)blockEntity)).getInventory().m_8020_(ticker.getSlot()), ticker.getSlot());
            }
            int newState = ((BlockEntityTickingTankInventory)((Object)blockEntity)).getNewState();
            if (newState != ((BlockEntityTickingTankInventory)((Object)blockEntity)).currentState) {
                ((BlockEntityTickingTankInventory)((Object)blockEntity)).currentState = newState;
                ((BlockEntityTickingTankInventory)((Object)blockEntity)).onStateChanged();
            }
        }
    }
}

