/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomPartModelBaked
extends DynamicItemAndBlockModel {
    private final Map<IBroomPart, BakedModel> broomPartModels = Maps.newHashMap();
    private final List<BakedQuad> quads;
    private final RandomSource rand = RandomSource.m_216327_();

    public BroomPartModelBaked() {
        super(true, false);
        this.quads = Collections.emptyList();
    }

    public BroomPartModelBaked(List<BakedQuad> quads) {
        super(false, true);
        this.quads = Objects.requireNonNull(quads);
    }

    public List<BakedQuad> getGeneralQuads() {
        return this.quads;
    }

    public void addBroomPartModel(IBroomPart part, BakedModel bakedModel) {
        this.broomPartModels.put(part, bakedModel);
    }

    public boolean m_7547_() {
        return true;
    }

    public BakedModel handleBlockState(@Nullable BlockState blockState, @Nullable Direction direction, @Nonnull RandomSource random, @Nonnull ModelData iModelData, @Nullable RenderType renderType) {
        throw new UnsupportedOperationException();
    }

    public BakedModel handleItemState(ItemStack itemStack, Level world, LivingEntity entity) {
        LinkedList quads = Lists.newLinkedList();
        Object part = BroomParts.REGISTRY.getPartFromItem(itemStack);
        BakedModel model = this.broomPartModels.get(part);
        if (model != null) {
            quads.addAll(this.color(model.m_213637_(null, this.getRenderingSide(), this.rand), part.getModelColor()));
        }
        return new BroomPartModelBaked(quads);
    }

    private Collection<? extends BakedQuad> color(List<BakedQuad> quads, int color) {
        ArrayList offsetQuads = Lists.newArrayListWithExpectedSize((int)quads.size());
        for (BakedQuad quad : quads) {
            int[] vertexData = Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length);
            for (int i = 0; i < vertexData.length / 8; ++i) {
                vertexData[i * 8 + 3] = color;
            }
            offsetQuads.add(new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), false));
        }
        return offsetQuads;
    }

    public TextureAtlasSprite m_6160_() {
        return null;
    }

    public ItemTransforms m_7442_() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }
}

