/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.RegistryEntries;

public class EntityControlledZombie
extends Monster {
    private static final EntityDataAccessor<Integer> WATCHERID_TTL = SynchedEntityData.m_135353_(EntityControlledZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityControlledZombie(EntityType<? extends EntityControlledZombie> entityType, Level world) {
        super(entityType, world);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 2000, 0));
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    public EntityControlledZombie(Level world) {
        this(RegistryEntries.ENTITY_CONTROLLED_ZOMBIE, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 64.0f));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WATCHERID_TTL, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ttl", this.getTtl());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTtl(tag.m_128451_("ttl"));
    }

    public int getTtl() {
        return (Integer)this.f_19804_.m_135370_(WATCHERID_TTL);
    }

    public void setTtl(int ttl) {
        this.f_19804_.m_135381_(WATCHERID_TTL, (Object)ttl);
    }

    public boolean m_6549_(EntityType<?> type) {
        return true;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12608_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_()) {
            int ttl = this.getTtl();
            this.setTtl(--ttl);
            if (ttl == 0) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

