/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.EvilCraftSoundEvents;

public abstract class ItemAbstractFocus
extends Item {
    private static final int TICK_MODULUS = 3;

    public ItemAbstractFocus(Item.Properties properties) {
        super(properties);
        if (MinecraftHelpers.isClientSide()) {
            this.registerProperties();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void registerProperties() {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)new ItemPropertyFunction(){

            @OnlyIn(value=Dist.CLIENT)
            public float m_141951_(ItemStack stack, ClientLevel worldIn, LivingEntity entityIn, int id) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemStack = entityIn.m_21211_();
                return !itemStack.m_41619_() && itemStack.m_41720_() instanceof ItemAbstractFocus ? (float)(stack.m_41779_() - entityIn.m_21212_()) / 20.0f : 0.0f;
            }
        });
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)new ItemPropertyFunction(){

            @OnlyIn(value=Dist.CLIENT)
            public float m_141951_(ItemStack stack, ClientLevel worldIn, LivingEntity entityIn, int id) {
                return entityIn != null && entityIn.m_6117_() && entityIn.m_21211_() == stack ? 1.0f : 0.0f;
            }
        });
    }

    private int getItemInUseDuration(LivingEntity player) {
        return Math.max(0, player.m_21252_() - player.m_21212_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.getItemInUseDuration((LivingEntity)player) > 0) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        player.m_6672_(hand);
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack itemStack) {
        return Integer.MAX_VALUE;
    }

    public void m_5551_(ItemStack itemStack, Level world, LivingEntity player, int duration) {
        if (player.f_19853_.m_5776_() && this.getItemInUseDuration(player) > 6) {
            player.m_5496_(EvilCraftSoundEvents.effect_vengeancebeam_stop, 0.6f + player.f_19853_.f_46441_.m_188501_() * 0.2f, 1.0f);
        }
    }

    protected abstract ThrowableProjectile newBeamEntity(LivingEntity var1);

    public void onUsingTick(ItemStack itemStack, LivingEntity player, int remaining) {
        int duration = this.m_8105_(itemStack) - remaining;
        if (duration > 6) {
            if (WorldHelpers.efficientTick((Level)player.f_19853_, (int)3, (int[])new int[]{player.m_19879_()})) {
                ThrowableProjectile beam = this.newBeamEntity(player);
                if (!player.f_19853_.m_5776_()) {
                    beam.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.5f, 1.0f);
                    player.f_19853_.m_7967_((Entity)beam);
                }
            }
        } else if (duration == 3 && player.f_19853_.m_5776_()) {
            player.m_5496_(EvilCraftSoundEvents.effect_vengeancebeam_start, 0.6f + player.f_19853_.f_46441_.m_188501_() * 0.2f, 1.0f);
        }
    }
}

