/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemBiomeExtract;

public class ItemBiomeExtractConfig
extends ItemConfig {
    @ConfigurableProperty(category="item", comment="If creative versions for all variants should be added to the creative tab.", requiresMcRestart=true)
    public static boolean creativeTabVariants = true;
    @ConfigurableProperty(category="item", comment="A list of biome names for which no Biome Extracts may be created.")
    public static List<String> craftingBlacklist = Lists.newArrayList();
    @ConfigurableProperty(category="item", comment="A list of biome names for which no Biome Extracts may be used.")
    public static List<String> usageBlacklist = Lists.newArrayList();

    public ItemBiomeExtractConfig() {
        super((ModBase)EvilCraft._instance, "biome_extract", eConfig -> new ItemBiomeExtract(new Item.Properties().m_41491_(EvilCraft._instance.getDefaultItemGroup())));
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onModLoaded(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new ItemBiomeExtract.ItemColor(), new ItemLike[]{(ItemLike)this.getInstance()});
    }

    public static boolean isCraftingBlacklisted(Registry<Biome> biomeRegistry, Biome biome) {
        return craftingBlacklist.contains(biomeRegistry.m_7981_((Object)biome).toString());
    }

    public static boolean isUsageBlacklisted(Registry<Biome> biomeRegistry, Biome biome) {
        return usageBlacklist.contains(biomeRegistry.m_7981_((Object)biome).toString());
    }
}

