/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.event.CurioUnequipEvent;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.mixin.core.AccessorEntity;

public class CurioSlot
extends SlotItemHandler {
    private final String identifier;
    private final Player player;
    private final SlotContext slotContext;
    private NonNullList<Boolean> renderStatuses;

    public CurioSlot(Player player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders) {
        super((IItemHandler)handler, index, xPosition, yPosition);
        this.identifier = identifier;
        this.renderStatuses = renders;
        this.player = player;
        this.slotContext = new SlotContext(identifier, (LivingEntity)player, index, this instanceof CosmeticCurioSlot, this instanceof CosmeticCurioSlot || (Boolean)renders.get(index) != false);
        this.setBackground(InventoryMenu.f_39692_, player.m_20193_().m_5776_() ? CuriosApi.getIconHelper().getIcon(identifier) : new ResourceLocation("curios", "slot/empty_curio_slot"));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean getRenderStatus() {
        return this.renderStatuses.size() > this.getSlotIndex() && (Boolean)this.renderStatuses.get(this.getSlotIndex()) != false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        return I18n.m_118938_((String)("curios.identifier." + this.identifier), (Object[])new Object[0]);
    }

    public void m_5852_(@Nonnull ItemStack stack) {
        ItemStack current = this.m_7993_();
        boolean flag = current.m_41619_() && stack.m_41619_();
        super.m_5852_(stack);
        if (!(flag || ItemStack.m_41746_((ItemStack)current, (ItemStack)stack) || ((AccessorEntity)this.player).getFirstTick())) {
            CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onEquipFromUse(this.slotContext));
        }
    }

    public boolean m_5857_(@Nonnull ItemStack stack) {
        CurioEquipEvent equipEvent = new CurioEquipEvent(stack, this.slotContext);
        MinecraftForge.EVENT_BUS.post((Event)equipEvent);
        Event.Result result = equipEvent.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        return result == Event.Result.ALLOW || CuriosApi.getCuriosHelper().isStackValid(this.slotContext, stack) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canEquip(this.slotContext)).orElse(true) != false && super.m_5857_(stack);
    }

    public boolean m_8010_(Player playerIn) {
        ItemStack stack = this.m_7993_();
        CurioUnequipEvent unequipEvent = new CurioUnequipEvent(stack, this.slotContext);
        MinecraftForge.EVENT_BUS.post((Event)unequipEvent);
        Event.Result result = unequipEvent.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        return result == Event.Result.ALLOW || (stack.m_41619_() || playerIn.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)stack)) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canUnequip(this.slotContext)).orElse(true) != false && super.m_8010_(playerIn);
    }
}

