/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.mysticalagriculture.item.WateringCanItem;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceWateringCanItem
extends WateringCanItem {
    private final ChatFormatting textColor;

    public EssenceWateringCanItem(int range, double chance, ChatFormatting textColor, Function<Item.Properties, Item.Properties> properties) {
        super(range, chance, properties.compose(p -> p.m_41487_(1)));
        this.textColor = textColor;
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)false);
            NBTHelper.setBoolean((ItemStack)stack, (String)"Active", (boolean)false);
            items.add((Object)stack);
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        BlockHitResult result;
        if (selected && NBTHelper.getBoolean((ItemStack)stack, (String)"Active") && entity instanceof Player && (result = EssenceWateringCanItem.m_41435_((Level)world, (Player)(player = (Player)entity), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).m_6662_() != HitResult.Type.MISS) {
            this.doWater(stack, world, player, result.m_82425_(), result.m_82434_());
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Active");
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockState state;
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult trace = EssenceWateringCanItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water") && player.m_6047_()) {
                NBTHelper.flipBoolean((ItemStack)stack, (String)"Active");
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.m_82425_();
        Direction direction = trace.m_82434_();
        if (world.m_7966_(player, pos) && player.m_36204_(pos.m_121945_(direction), direction, stack) && (state = world.m_8055_(pos)).m_60767_() == Material.f_76305_) {
            NBTHelper.setString((ItemStack)stack, (String)"ID", (String)UUID.randomUUID().toString());
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)true);
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Active")) {
            return InteractionResult.PASS;
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        String rangeString = String.valueOf(this.range);
        MutableComponent rangeNumber = Component.m_237113_((String)(rangeString + "x" + rangeString)).m_130940_(this.textColor);
        tooltip.add((Component)ModTooltips.TOOL_AREA.args(new Object[]{rangeNumber}).build());
    }
}

