/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.event.server.ServerReloadedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.mixin.StructureTemplatePoolAccessor;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.blay09.mods.waystones.worldgen.WaystonePlacement;
import net.blay09.mods.waystones.worldgen.WaystoneStructurePoolElement;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ModWorldGen {
    private static final ResourceLocation villageWaystoneStructure = new ResourceLocation("waystones", "village/common/waystone");
    private static final ResourceLocation desertVillageWaystoneStructure = new ResourceLocation("waystones", "village/desert/waystone");
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    private static DeferredObject<WaystoneFeature> waystoneFeature;
    private static DeferredObject<WaystoneFeature> mossyWaystoneFeature;
    private static DeferredObject<WaystoneFeature> sandyWaystoneFeature;
    private static DeferredObject<ConfiguredFeature<NoneFeatureConfiguration, WaystoneFeature>> configuredWaystoneFeature;
    private static DeferredObject<ConfiguredFeature<NoneFeatureConfiguration, WaystoneFeature>> configuredMossyWaystoneFeature;
    private static DeferredObject<ConfiguredFeature<NoneFeatureConfiguration, WaystoneFeature>> configuredSandyWaystoneFeature;
    private static DeferredObject<PlacedFeature> placedWaystoneFeature;
    private static DeferredObject<PlacedFeature> placedMossyWaystoneFeature;
    private static DeferredObject<PlacedFeature> placedSandyWaystoneFeature;
    public static DeferredObject<PlacementModifierType<WaystonePlacement>> waystonePlacement;

    public static void initialize(BalmWorldGen worldGen) {
        waystoneFeature = worldGen.registerFeature(ModWorldGen.id("waystone"), () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.waystone.m_49966_()));
        mossyWaystoneFeature = worldGen.registerFeature(ModWorldGen.id("mossy_waystone"), () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.mossyWaystone.m_49966_()));
        sandyWaystoneFeature = worldGen.registerFeature(ModWorldGen.id("sandy_waystone"), () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.sandyWaystone.m_49966_()));
        waystonePlacement = worldGen.registerPlacementModifier(ModWorldGen.id("waystone"), () -> () -> WaystonePlacement.CODEC);
        configuredWaystoneFeature = worldGen.registerConfiguredFeature(ModWorldGen.id("waystone"), () -> waystoneFeature.get(), () -> FeatureConfiguration.f_67737_);
        configuredMossyWaystoneFeature = worldGen.registerConfiguredFeature(ModWorldGen.id("mossy_waystone"), () -> mossyWaystoneFeature.get(), () -> FeatureConfiguration.f_67737_);
        configuredSandyWaystoneFeature = worldGen.registerConfiguredFeature(ModWorldGen.id("sandy_waystone"), () -> sandyWaystoneFeature.get(), () -> FeatureConfiguration.f_67737_);
        placedWaystoneFeature = worldGen.registerPlacedFeature(ModWorldGen.id("waystone"), () -> configuredWaystoneFeature.get(), new PlacementModifier[]{new WaystonePlacement()});
        placedMossyWaystoneFeature = worldGen.registerPlacedFeature(ModWorldGen.id("mossy_waystone"), () -> configuredMossyWaystoneFeature.get(), new PlacementModifier[]{new WaystonePlacement()});
        placedSandyWaystoneFeature = worldGen.registerPlacedFeature(ModWorldGen.id("sandy_waystone"), () -> configuredSandyWaystoneFeature.get(), new PlacementModifier[]{new WaystonePlacement()});
        TagKey IS_DESERT = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("waystones", "is_desert"));
        TagKey IS_SWAMP = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("waystones", "is_swamp"));
        TagKey IS_MUSHROOM = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("waystones", "is_mushroom"));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)IS_DESERT), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.SANDY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)BiomeTags.f_207610_), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)IS_SWAMP), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)IS_MUSHROOM), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesNeitherTag(List.of(IS_SWAMP, IS_DESERT, BiomeTags.f_207610_, IS_MUSHROOM)), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.DEFAULT));
        Balm.getEvents().onEvent(ServerStartedEvent.class, event -> ModWorldGen.setupVillageWorldGen((RegistryAccess)event.getServer().m_206579_()));
        Balm.getEvents().onEvent(ServerReloadedEvent.class, event -> ModWorldGen.setupVillageWorldGen((RegistryAccess)event.getServer().m_206579_()));
        Registry.f_122897_.m_6612_(new ResourceLocation("repurposed_structures", "json_conditions")).ifPresent(registry -> Registry.m_122965_((Registry)registry, (ResourceLocation)new ResourceLocation("waystones", "config"), () -> WaystonesConfig.getActive().spawnInVillages() || WaystonesConfig.getActive().forceSpawnInVillages()));
    }

    private static BiomePredicate matchesTag(TagKey<Biome> tag) {
        return (resourceLocation, biome) -> biome.m_203656_(tag);
    }

    private static BiomePredicate matchesNeitherTag(List<TagKey<Biome>> tags) {
        return (resourceLocation, biome) -> {
            for (TagKey tag : tags) {
                if (!biome.m_203656_(tag)) continue;
                return false;
            }
            return true;
        };
    }

    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }

    private static ResourceLocation getWaystoneFeature(WorldGenStyle biomeWorldGenStyle) {
        WorldGenStyle worldGenStyle = WaystonesConfig.getActive().worldGenStyle();
        return switch (worldGenStyle) {
            case WorldGenStyle.MOSSY -> configuredMossyWaystoneFeature.getIdentifier();
            case WorldGenStyle.SANDY -> configuredSandyWaystoneFeature.getIdentifier();
            case WorldGenStyle.BIOME -> {
                switch (biomeWorldGenStyle) {
                    case SANDY: {
                        yield configuredSandyWaystoneFeature.getIdentifier();
                    }
                    case MOSSY: {
                        yield configuredMossyWaystoneFeature.getIdentifier();
                    }
                }
                yield configuredWaystoneFeature.getIdentifier();
            }
            default -> configuredWaystoneFeature.getIdentifier();
        };
    }

    public static void setupVillageWorldGen(RegistryAccess registryAccess) {
        if (WaystonesConfig.getActive().spawnInVillages() || WaystonesConfig.getActive().forceSpawnInVillages()) {
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/taiga/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(RegistryAccess registryAccess, String villagePiece, ResourceLocation waystoneStructure, int weight) {
        StructureTemplatePool pool;
        Holder emptyProcessorList = registryAccess.m_175515_(Registry.f_122883_).m_206081_(EMPTY_PROCESSOR_LIST_KEY);
        LegacySinglePoolElement piece = (LegacySinglePoolElement)StructurePoolElement.m_210512_((String)waystoneStructure.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        if (piece instanceof WaystoneStructurePoolElement) {
            WaystoneStructurePoolElement element = (WaystoneStructurePoolElement)piece;
            element.setIsWaystone(true);
        }
        if ((pool = (StructureTemplatePool)registryAccess.m_175515_(Registry.f_122884_).m_6612_(new ResourceLocation(villagePiece)).orElse(null)) != null) {
            StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)pool;
            ObjectArrayList listOfPieces = new ObjectArrayList(poolAccessor.getTemplates());
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add((Object)piece);
            }
            poolAccessor.setTemplates((ObjectArrayList<StructurePoolElement>)listOfPieces);
            ArrayList<Pair<StructurePoolElement, Integer>> listOfWeightedPieces = new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccessor.getRawTemplates());
            listOfWeightedPieces.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
            poolAccessor.setRawTemplates(listOfWeightedPieces);
        }
    }
}

