/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import journeymap.client.cartography.color.RGB;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import org.lwjgl.stb.STBImageResize;

public class ImageUtil {
    public static NativeImage getSizedImage(int width, int height, NativeImage from, boolean autoClose) {
        NativeImage scaledImage = new NativeImage(from.m_85102_(), width, height, false);
        STBImageResize.nstbir_resize_uint8_generic((long)from.f_84964_, (int)from.m_84982_(), (int)from.m_85084_(), (int)0, (long)scaledImage.f_84964_, (int)width, (int)height, (int)0, (int)from.m_85102_().m_85161_(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return scaledImage;
    }

    public static NativeImage getScaledImage(float scale, NativeImage from, boolean autoClose) {
        int scaledWidth = (int)((float)from.m_84982_() * scale);
        int scaledHeight = (int)((float)from.m_85084_() * scale);
        NativeImage scaledImage = new NativeImage(from.m_85102_(), scaledWidth, scaledHeight, false);
        STBImageResize.nstbir_resize_uint8_generic((long)from.f_84964_, (int)from.m_84982_(), (int)from.m_85084_(), (int)0, (long)scaledImage.f_84964_, (int)scaledWidth, (int)scaledHeight, (int)0, (int)from.m_85102_().m_85161_(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return scaledImage;
    }

    public static ComparableNativeImage getComparableSubImage(int x, int y, int width, int height, NativeImage from, boolean autoClose) {
        ComparableNativeImage to = new ComparableNativeImage(from.m_85102_(), width, height);
        return (ComparableNativeImage)ImageUtil.getSubImage(x, y, width, height, from, to, autoClose);
    }

    public static NativeImage getSubImage(int x, int y, int width, int height, NativeImage from, boolean autoClose) {
        NativeImage to = new NativeImage(width, height, false);
        return ImageUtil.getSubImage(x, y, width, height, from, to, autoClose);
    }

    public static NativeImage getSubImage(int x, int y, int width, int height, NativeImage from, NativeImage to, boolean autoClose) {
        if (from.f_84964_ == 0L) {
            throw new IllegalStateException("Image is not allocated. " + from);
        }
        if (to.m_85102_() != from.m_85102_()) {
            throw new UnsupportedOperationException("getSubImage only works for images of the same format.");
        }
        int i = from.m_85102_().m_85161_();
        STBImageResize.nstbir_resize_uint8_generic((long)(from.f_84964_ + ((long)x + (long)y * (long)from.m_84982_()) * (long)i), (int)width, (int)height, (int)(from.m_84982_() * i), (long)to.f_84964_, (int)to.m_84982_(), (int)to.m_85084_(), (int)0, (int)from.m_85102_().m_85161_(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return to;
    }

    public static NativeImage recolorImage(NativeImage image, int color) {
        NativeImage tintedImage = new NativeImage(image.m_84982_(), image.m_85084_(), false);
        tintedImage.m_85054_(image);
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_84982_(); ++y) {
                int imgColor = image.m_84985_(x, y);
                if (NativeImage.m_84983_((int)imgColor) <= 1) continue;
                tintedImage.m_166411_(x, y, RGB.toRgba(color, 0.75f));
            }
        }
        return tintedImage;
    }

    public static void closeSafely(NativeImage image) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> ((NativeImage)image).close());
        } else {
            image.close();
        }
    }

    public static NativeImage getNewBlankImage(int width, int height) {
        NativeImage image = new NativeImage(width, height, false);
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_85084_(); ++y) {
                image.m_84988_(x, y, RGB.toRgba(0, 0.0f));
            }
        }
        return image;
    }

    public static void clearAndClose(NativeImage image) {
        if (image != null) {
            try {
                image.close();
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Failed to clear and close image: ", (Throwable)e);
            }
        }
    }
}

