/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.Coord4D;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.radiation.IRadiationManager;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class FissionReactorMultiblockData
extends MultiblockData
implements IValveHandler {
    private static final double INVERSE_INSULATION_COEFFICIENT = 10000.0;
    private static final double INVERSE_CONDUCTION_COEFFICIENT = 10.0;
    private static final double waterConductivity = 0.5;
    public static final double MIN_DAMAGE_TEMPERATURE = 1200.0;
    public static final double MAX_DAMAGE_TEMPERATURE = 1800.0;
    public static final double MAX_DAMAGE = 100.0;
    private static final double EXPLOSION_CHANCE = 1.953125E-6;
    public final Set<FissionReactorValidator.FormedAssembly> assemblies = new LinkedHashSet<FissionReactorValidator.FormedAssembly>();
    @ContainerSync(setter="setAssemblies")
    @SyntheticComputerMethod(getter="getFuelAssemblies")
    private int fuelAssemblies = 0;
    @ContainerSync
    @SyntheticComputerMethod(getter="getFuelSurfaceArea")
    public int surfaceArea;
    @ContainerSync
    public IGasTank gasCoolantTank;
    @ContainerSync
    public VariableCapacityFluidTank fluidCoolantTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getFuel", "getFuelCapacity", "getFuelNeeded", "getFuelFilledPercentage"})
    public IGasTank fuelTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getHeatedCoolant", "getHeatedCoolantCapacity", "getHeatedCoolantNeeded", "getHeatedCoolantFilledPercentage"})
    public IGasTank heatedCoolantTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getWaste", "getWasteCapacity", "getWasteNeeded", "getWasteFilledPercentage"})
    public IGasTank wasteTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"})
    public VariableHeatCapacitor heatCapacitor;
    private double biomeAmbientTemp;
    @ContainerSync
    @SyntheticComputerMethod(getter="getEnvironmentalLoss")
    public double lastEnvironmentLoss = 0.0;
    @ContainerSync
    @SyntheticComputerMethod(getter="getHeatingRate")
    public long lastBoilRate = 0L;
    @ContainerSync
    @SyntheticComputerMethod(getter="getActualBurnRate")
    public double lastBurnRate = 0.0;
    private boolean clientBurning;
    @ContainerSync
    public double reactorDamage = 0.0;
    @ContainerSync
    @SyntheticComputerMethod(getter="getBurnRate")
    public double rateLimit;
    public double burnRemaining;
    public double partialWaste;
    @ContainerSync
    private boolean active;
    @ContainerSync
    private boolean forceDisable;
    private int cooledCoolantCapacity;
    private long heatedCoolantCapacity;
    private long fuelCapacity;
    private AABB hotZone;
    public float prevCoolantScale;
    private float prevFuelScale;
    public float prevHeatedCoolantScale;
    private float prevWasteScale;

    public FissionReactorMultiblockData(TileEntityFissionReactorCasing tile) {
        super((BlockEntity)tile);
        this.rateLimit = MekanismGeneratorsConfig.generators.defaultBurnRate.get();
        this.burnRemaining = 0.0;
        this.partialWaste = 0.0;
        this.biomeAmbientTemp = HeatAPI.getAmbientTemp((LevelReader)tile.m_58904_(), (BlockPos)tile.getTilePos());
        LongSupplier fuelCapacitySupplier = () -> this.fuelCapacity;
        this.fluidCoolantTank = VariableCapacityFluidTank.input((MultiblockData)this, () -> this.cooledCoolantCapacity, fluid -> MekanismTags.Fluids.WATER_LOOKUP.contains((Object)fluid.getFluid()) && this.gasCoolantTank.isEmpty(), (IContentsListener)this);
        this.fluidTanks.add(this.fluidCoolantTank);
        this.gasCoolantTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, () -> this.cooledCoolantCapacity, gas -> gas.has(GasAttributes.CooledCoolant.class) && this.fluidCoolantTank.isEmpty(), (IContentsListener)this);
        this.fuelTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, fuelCapacitySupplier, gas -> gas == MekanismGases.FISSILE_FUEL.getChemical(), ChemicalAttributeValidator.ALWAYS_ALLOW, this.createSaveAndComparator());
        this.heatedCoolantTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.output((MultiblockData)this, () -> this.heatedCoolantCapacity, gas -> gas == MekanismGases.STEAM.get() || gas.has(GasAttributes.HeatedCoolant.class), (IContentsListener)this);
        this.wasteTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.output((MultiblockData)this, fuelCapacitySupplier, gas -> gas == MekanismGases.NUCLEAR_WASTE.getChemical(), ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this);
        Collections.addAll(this.gasTanks, this.fuelTank, this.heatedCoolantTank, this.wasteTank, this.gasCoolantTank);
        this.heatCapacitor = VariableHeatCapacitor.create((double)MekanismGeneratorsConfig.generators.fissionCasingHeatCapacity.get(), () -> 10.0, () -> 10000.0, () -> this.biomeAmbientTemp, (IContentsListener)this);
        this.heatCapacitors.add(this.heatCapacitor);
    }

    public void onCreated(Level world) {
        super.onCreated(world);
        this.biomeAmbientTemp = this.calculateAverageAmbientTemperature(world);
        this.heatCapacitor.setHeatCapacity(MekanismGeneratorsConfig.generators.fissionCasingHeatCapacity.get() * (double)this.locations.size(), true);
        this.hotZone = new AABB(this.getMinPos().m_7918_(1, 1, 1), this.getMaxPos());
    }

    public boolean tick(Level world) {
        boolean needsPacket = super.tick(world);
        if (this.isActive()) {
            this.burnFuel(world);
        } else {
            this.lastBurnRate = 0.0;
        }
        if (this.isBurning() != this.clientBurning) {
            needsPacket = true;
            this.clientBurning = this.isBurning();
        }
        this.handleCoolant();
        this.lastEnvironmentLoss = this.simulateEnvironment();
        this.updateHeatCapacitors(null);
        this.handleDamage(world);
        this.radiateEntities(world);
        float coolantScale = MekanismUtils.getScale((float)this.prevCoolantScale, (IExtendedFluidTank)this.fluidCoolantTank);
        float fuelScale = MekanismUtils.getScale((float)this.prevFuelScale, (IChemicalTank)this.fuelTank);
        float steamScale = MekanismUtils.getScale((float)this.prevHeatedCoolantScale, (IChemicalTank)this.heatedCoolantTank);
        float wasteScale = MekanismUtils.getScale((float)this.prevWasteScale, (IChemicalTank)this.wasteTank);
        if (coolantScale != this.prevCoolantScale || fuelScale != this.prevFuelScale || steamScale != this.prevHeatedCoolantScale || wasteScale != this.prevWasteScale) {
            needsPacket = true;
            this.prevCoolantScale = coolantScale;
            this.prevFuelScale = fuelScale;
            this.prevHeatedCoolantScale = steamScale;
            this.prevWasteScale = wasteScale;
        }
        return needsPacket;
    }

    public double simulateEnvironment() {
        double invConduction = 20010.0;
        double tempToTransfer = (this.heatCapacitor.getTemperature() - this.biomeAmbientTemp) / invConduction;
        this.heatCapacitor.handleHeat(-tempToTransfer * this.heatCapacitor.getHeatCapacity());
        return Math.max(tempToTransfer, 0.0);
    }

    public void readUpdateTag(CompoundTag tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            this.prevCoolantScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scaleAlt", scale -> {
            this.prevFuelScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale2", scale -> {
            this.prevHeatedCoolantScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale3", scale -> {
            this.prevWasteScale = scale;
        });
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"volume", this::setVolume);
        NBTUtils.setFluidStackIfPresent((CompoundTag)tag, (String)"fluid", value -> this.fluidCoolantTank.setStack(value));
        NBTUtils.setGasStackIfPresent((CompoundTag)tag, (String)"gas", value -> this.fuelTank.setStack((ChemicalStack)value));
        NBTUtils.setGasStackIfPresent((CompoundTag)tag, (String)"gas1", value -> this.heatedCoolantTank.setStack((ChemicalStack)value));
        NBTUtils.setGasStackIfPresent((CompoundTag)tag, (String)"gas2", value -> this.wasteTank.setStack((ChemicalStack)value));
        this.readValves(tag);
        this.assemblies.clear();
        if (tag.m_128425_("assemblies", 9)) {
            ListTag list = tag.m_128437_("assemblies", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.assemblies.add(FissionReactorValidator.FormedAssembly.read(list.m_128728_(i)));
            }
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        super.writeUpdateTag(tag);
        tag.m_128350_("scale", this.prevCoolantScale);
        tag.m_128350_("scaleAlt", this.prevFuelScale);
        tag.m_128350_("scale2", this.prevHeatedCoolantScale);
        tag.m_128350_("scale3", this.prevWasteScale);
        tag.m_128405_("volume", this.getVolume());
        tag.m_128365_("fluid", (Tag)this.fluidCoolantTank.getFluid().writeToNBT(new CompoundTag()));
        tag.m_128365_("gas", (Tag)((GasStack)this.fuelTank.getStack()).write(new CompoundTag()));
        tag.m_128365_("gas1", (Tag)((GasStack)this.heatedCoolantTank.getStack()).write(new CompoundTag()));
        tag.m_128365_("gas2", (Tag)((GasStack)this.wasteTank.getStack()).write(new CompoundTag()));
        this.writeValves(tag);
        ListTag list = new ListTag();
        this.assemblies.forEach(assembly -> list.add((Object)assembly.write()));
        tag.m_128365_("assemblies", (Tag)list);
    }

    private void handleDamage(Level world) {
        double lastDamage = this.reactorDamage;
        double temp = this.heatCapacitor.getTemperature();
        if (temp > 1200.0) {
            double damageRate = Math.min(temp, 1800.0) / 12000.0;
            this.reactorDamage += damageRate;
        } else {
            double repairRate = (1200.0 - temp) / 120000.0;
            this.reactorDamage = Math.max(0.0, this.reactorDamage - repairRate);
        }
        if (this.reactorDamage >= 100.0 && temp >= 1200.0) {
            if (this.isForceDisabled() && MekanismGeneratorsConfig.generators.fissionMeltdownsEnabled.get()) {
                this.setForceDisable(false);
                this.createMeltdown(world);
            } else if (world.f_46441_.m_188500_() < this.reactorDamage / 100.0 * MekanismGeneratorsConfig.generators.fissionMeltdownChance.get()) {
                if (MekanismGeneratorsConfig.generators.fissionMeltdownsEnabled.get()) {
                    this.createMeltdown(world);
                } else {
                    this.setForceDisable(true);
                }
            }
        } else if (this.reactorDamage < 100.0 && temp < 1200.0) {
            this.setForceDisable(false);
        }
        if (this.reactorDamage != lastDamage) {
            this.markDirty();
        }
    }

    private void createMeltdown(Level world) {
        RadiationManager.INSTANCE.createMeltdown(world, this.getMinPos(), this.getMaxPos(), this.heatCapacitor.getHeat(), 1.953125E-6, MekanismGeneratorsConfig.generators.fissionMeltdownRadius.get(), this.inventoryID);
    }

    public void meltdownHappened(Level world) {
        if (this.isFormed()) {
            MultiblockCache cache;
            IRadiationManager radiationManager = MekanismAPI.getRadiationManager();
            if (radiationManager.isRadiationEnabled()) {
                double radiation = this.getTankRadioactivityAndDump(this.fuelTank) + this.getWasteTankRadioactivity(true) + this.getTankRadioactivityAndDump(this.gasCoolantTank) + this.getTankRadioactivityAndDump(this.heatedCoolantTank);
                radiationManager.radiate(new Coord4D((Vec3i)this.getBounds().getCenter(), world), radiation *= MekanismGeneratorsConfig.generators.fissionMeltdownRadiationMultiplier.get());
            }
            this.heatedCoolantTank.setEmpty();
            this.active = false;
            this.reactorDamage = MekanismGeneratorsConfig.generators.fissionPostMeltdownDamage.get();
            this.burnRemaining = 0.0;
            this.partialWaste = 0.0;
            this.heatCapacitor.setHeat(this.heatCapacitor.getHeatCapacity() * this.biomeAmbientTemp);
            MultiblockManager.CacheWrapper cacheWrapper = (MultiblockManager.CacheWrapper)MekanismGenerators.fissionReactorManager.inventories.get(this.inventoryID);
            if (cacheWrapper != null && (cache = cacheWrapper.getCache()) != null) {
                cache.sync((MultiblockData)this);
            }
        }
    }

    private double getWasteTankRadioactivity(boolean dump) {
        if (this.wasteTank.isEmpty()) {
            return ((Gas)MekanismGases.NUCLEAR_WASTE.get()).mapAttributeToDouble(GasAttributes.Radiation.class, attribute -> this.partialWaste * attribute.getRadioactivity());
        }
        return ((GasStack)this.wasteTank.getStack()).mapAttributeToDouble(GasAttributes.Radiation.class, (stored, attribute) -> {
            if (dump) {
                this.wasteTank.setEmpty();
            }
            return ((double)stored.getAmount() + this.partialWaste) * attribute.getRadioactivity();
        });
    }

    private double getTankRadioactivityAndDump(IGasTank tank) {
        if (!tank.isEmpty()) {
            return ((GasStack)tank.getStack()).mapAttributeToDouble(GasAttributes.Radiation.class, (stored, attribute) -> {
                tank.setEmpty();
                return (double)stored.getAmount() * attribute.getRadioactivity();
            });
        }
        return 0.0;
    }

    private void handleCoolant() {
        double temp = this.heatCapacitor.getTemperature();
        double heat = this.getBoilEfficiency() * (temp - HeatUtils.BASE_BOIL_TEMP) * this.heatCapacitor.getHeatCapacity();
        if (!this.fluidCoolantTank.isEmpty()) {
            double caseCoolantHeat = heat * 0.5;
            this.lastBoilRate = this.clampCoolantHeated(HeatUtils.getSteamEnergyEfficiency() * caseCoolantHeat / HeatUtils.getWaterThermalEnthalpy(), this.fluidCoolantTank.getFluidAmount());
            if (this.lastBoilRate > 0L) {
                MekanismUtils.logMismatchedStackSize((long)this.fluidCoolantTank.shrinkStack((int)this.lastBoilRate, Action.EXECUTE), (long)this.lastBoilRate);
                this.heatedCoolantTank.insert((ChemicalStack)MekanismGases.STEAM.getStack(this.lastBoilRate), Action.EXECUTE, AutomationType.INTERNAL);
                caseCoolantHeat = (double)this.lastBoilRate * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
                this.heatCapacitor.handleHeat(-caseCoolantHeat);
            }
        } else if (!this.gasCoolantTank.isEmpty()) {
            ((GasStack)this.gasCoolantTank.getStack()).ifAttributePresent(GasAttributes.CooledCoolant.class, coolantType -> {
                double caseCoolantHeat = heat * coolantType.getConductivity();
                this.lastBoilRate = this.clampCoolantHeated(caseCoolantHeat / coolantType.getThermalEnthalpy(), this.gasCoolantTank.getStored());
                if (this.lastBoilRate > 0L) {
                    MekanismUtils.logMismatchedStackSize((long)this.gasCoolantTank.shrinkStack(this.lastBoilRate, Action.EXECUTE), (long)this.lastBoilRate);
                    this.heatedCoolantTank.insert((ChemicalStack)coolantType.getHeatedGas().getStack(this.lastBoilRate), Action.EXECUTE, AutomationType.INTERNAL);
                    caseCoolantHeat = (double)this.lastBoilRate * coolantType.getThermalEnthalpy();
                    this.heatCapacitor.handleHeat(-caseCoolantHeat);
                }
            });
        }
    }

    private long clampCoolantHeated(double heated, long stored) {
        return Mth.m_14053_((long)MathUtils.clampToLong((double)heated), (long)0L, (long)stored);
    }

    private void burnFuel(Level world) {
        double lastPartialWaste = this.partialWaste;
        double lastBurnRemaining = this.burnRemaining;
        double storedFuel = (double)this.fuelTank.getStored() + this.burnRemaining;
        double toBurn = Math.min(Math.min(this.rateLimit, storedFuel), (double)((long)this.fuelAssemblies * MekanismGeneratorsConfig.generators.burnPerAssembly.get()));
        this.fuelTank.setStackSize((long)(storedFuel -= toBurn), Action.EXECUTE);
        this.burnRemaining = storedFuel % 1.0;
        this.heatCapacitor.handleHeat(toBurn * ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFissionFuel.get()).doubleValue());
        this.partialWaste += toBurn;
        long newWaste = (long)Math.floor(this.partialWaste);
        if (newWaste > 0L) {
            this.partialWaste %= 1.0;
            long leftoverWaste = Math.max(0L, newWaste - this.wasteTank.getNeeded());
            GasStack wasteToAdd = MekanismGases.NUCLEAR_WASTE.getStack(newWaste);
            this.wasteTank.insert((ChemicalStack)wasteToAdd, Action.EXECUTE, AutomationType.INTERNAL);
            if (leftoverWaste > 0L && MekanismAPI.getRadiationManager().isRadiationEnabled()) {
                wasteToAdd.ifAttributePresent(GasAttributes.Radiation.class, attribute -> MekanismAPI.getRadiationManager().radiate(new Coord4D((Vec3i)this.getBounds().getCenter(), world), (double)leftoverWaste * attribute.getRadioactivity()));
            }
        }
        this.lastBurnRate = toBurn;
        if (lastPartialWaste != this.partialWaste || lastBurnRemaining != this.burnRemaining) {
            this.markDirty();
        }
    }

    private void radiateEntities(Level world) {
        List entitiesToRadiate;
        IRadiationManager radiationManager = MekanismAPI.getRadiationManager();
        if (radiationManager.isRadiationEnabled() && this.isBurning() && world.m_213780_().m_188502_() % 20 == 0 && !(entitiesToRadiate = this.getWorld().m_45976_(LivingEntity.class, this.hotZone)).isEmpty()) {
            double wasteRadiation = this.getWasteTankRadioactivity(false) / 3600.0;
            double magnitude = this.lastBurnRate + wasteRadiation;
            for (LivingEntity entity : entitiesToRadiate) {
                radiationManager.radiate(entity, magnitude);
            }
        }
    }

    void setForceDisable(boolean forceDisable) {
        if (this.forceDisable != forceDisable) {
            this.forceDisable = forceDisable;
            this.markDirty();
            if (this.forceDisable) {
                this.setActive(false);
            }
        }
    }

    @ComputerMethod
    public boolean isForceDisabled() {
        return this.forceDisable;
    }

    @ComputerMethod(nameOverride="getStatus")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (!(this.active == active || active && this.isForceDisabled())) {
            this.active = active;
            this.markDirty();
        }
    }

    public boolean isBurning() {
        return this.lastBurnRate > 0.0;
    }

    public boolean handlesSound(TileEntityFissionReactorCasing tile) {
        return this.getBounds().isOnCorner(tile.m_58899_());
    }

    @ComputerMethod
    public double getBoilEfficiency() {
        if (this.fuelAssemblies == 0) {
            return 0.0;
        }
        double avgSurfaceArea = (double)this.surfaceArea / (double)this.fuelAssemblies;
        return Math.min(1.0, avgSurfaceArea / MekanismGeneratorsConfig.generators.fissionSurfaceAreaTarget.get());
    }

    @ComputerMethod
    public long getMaxBurnRate() {
        return (long)this.fuelAssemblies * MekanismGeneratorsConfig.generators.burnPerAssembly.get();
    }

    @ComputerMethod
    public long getDamagePercent() {
        return Math.round(this.reactorDamage / 100.0 * 100.0);
    }

    public void setAssemblies(int assemblies) {
        if (this.fuelAssemblies != assemblies) {
            this.fuelAssemblies = assemblies;
            this.fuelCapacity = (long)assemblies * MekanismGeneratorsConfig.generators.maxFuelPerAssembly.get();
        }
    }

    public void setVolume(int volume) {
        if (this.getVolume() != volume) {
            super.setVolume(volume);
            this.cooledCoolantCapacity = volume * MekanismGeneratorsConfig.generators.fissionCooledCoolantPerTank.get();
            this.heatedCoolantCapacity = (long)volume * MekanismGeneratorsConfig.generators.fissionHeatedCoolantPerTank.get();
        }
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    public void setRateLimit(double rate) {
        if (this.rateLimit != (rate = Mth.m_14008_((double)rate, (double)0.0, (double)this.getMaxBurnRate()))) {
            this.rateLimit = rate;
            this.markDirty();
        }
    }

    @ComputerMethod
    private void activate() throws ComputerException {
        if (this.isActive()) {
            throw new ComputerException("Reactor is already active.");
        }
        if (this.isForceDisabled()) {
            throw new ComputerException("Reactor must reach safe damage and temperature levels before it can be reactivated.");
        }
        this.setActive(true);
    }

    @ComputerMethod
    private void scram() throws ComputerException {
        if (!this.isActive()) {
            throw new ComputerException("Scram requires the reactor to be active.");
        }
        this.setActive(false);
    }

    @ComputerMethod
    private void setBurnRate(double rate) throws ComputerException {
        rate = UnitDisplayUtils.roundDecimals((double)rate);
        long max = this.getMaxBurnRate();
        if (rate < 0.0 || rate > (double)max) {
            throw new ComputerException("Burn Rate '%.2f' is out of range must be between 0 and %d. (Inclusive)", new Object[]{rate, max});
        }
        this.setRateLimit(rate);
    }

    @ComputerMethod
    private Object getCoolant() {
        if (this.fluidCoolantTank.isEmpty() && !this.gasCoolantTank.isEmpty()) {
            return this.gasCoolantTank.getStack();
        }
        return this.fluidCoolantTank.getFluid();
    }

    @ComputerMethod
    private long getCoolantCapacity() {
        if (this.fluidCoolantTank.isEmpty() && !this.gasCoolantTank.isEmpty()) {
            return this.gasCoolantTank.getCapacity();
        }
        return this.fluidCoolantTank.getCapacity();
    }

    @ComputerMethod
    private long getCoolantNeeded() {
        if (this.fluidCoolantTank.isEmpty() && !this.gasCoolantTank.isEmpty()) {
            return this.gasCoolantTank.getNeeded();
        }
        return this.fluidCoolantTank.getNeeded();
    }

    @ComputerMethod
    private double getCoolantFilledPercentage() {
        if (this.fluidCoolantTank.isEmpty() && !this.gasCoolantTank.isEmpty()) {
            return (double)this.gasCoolantTank.getStored() / (double)this.gasCoolantTank.getCapacity();
        }
        return (double)this.fluidCoolantTank.getFluidAmount() / (double)this.fluidCoolantTank.getCapacity();
    }

    @ComputerMethod
    private double getHeatCapacity() {
        return this.heatCapacitor.getHeatCapacity();
    }
}

