/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseEntityBlock;
import appeng.block.IOwnerAwareBlockEntity;
import appeng.block.misc.LightDetectorBlock;
import appeng.block.networking.WirelessBlock;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AEBaseBlockItem
extends BlockItem {
    private final AEBaseBlock blockType;

    public AEBaseBlockItem(Block id, Item.Properties props) {
        super(id, props);
        this.blockType = (AEBaseBlock)id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void m_7373_(ItemStack itemStack, Level level, List<Component> toolTip, TooltipFlag advancedTooltips) {
        this.addCheckedInformation(itemStack, level, toolTip, advancedTooltips);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addCheckedInformation(ItemStack itemStack, Level level, List<Component> toolTip, TooltipFlag advancedTooltips) {
        this.blockType.m_5871_(itemStack, (BlockGetter)level, toolTip, advancedTooltips);
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public String m_5671_(ItemStack is) {
        return this.blockType.m_7705_();
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        Direction up = null;
        Direction forward = null;
        Direction side = context.m_43719_();
        Player player = context.m_43723_();
        if (this.blockType instanceof AEBaseEntityBlock) {
            if (this.blockType instanceof LightDetectorBlock) {
                up = side;
                forward = up == Direction.UP || up == Direction.DOWN ? Direction.SOUTH : Direction.UP;
            } else if (this.blockType instanceof WirelessBlock) {
                forward = side;
                up = forward == Direction.UP || forward == Direction.DOWN ? Direction.SOUTH : Direction.UP;
            } else {
                up = Direction.UP;
                forward = context.m_8125_().m_122424_();
                if (player != null) {
                    if (player.m_146909_() > 65.0f) {
                        up = forward.m_122424_();
                        forward = Direction.UP;
                    } else if (player.m_146909_() < -65.0f) {
                        up = forward.m_122424_();
                        forward = Direction.DOWN;
                    }
                }
            }
        }
        IOrientable ori = null;
        if (this.blockType instanceof IOrientableBlock) {
            ori = ((IOrientableBlock)((Object)this.blockType)).getOrientable((BlockGetter)context.m_43725_(), context.m_8083_());
            up = side;
            forward = Direction.SOUTH;
            if (up.m_122430_() == 0) {
                forward = Direction.UP;
            }
        }
        if (!this.blockType.isValidOrientation((LevelAccessor)context.m_43725_(), context.m_8083_(), forward, up)) {
            return InteractionResult.FAIL;
        }
        InteractionResult result = super.m_40576_(context);
        if (!result.m_19077_()) {
            return result;
        }
        if (this.blockType instanceof AEBaseEntityBlock && !(this.blockType instanceof LightDetectorBlock)) {
            Object blockEntity = ((AEBaseEntityBlock)this.blockType).getBlockEntity((BlockGetter)context.m_43725_(), context.m_8083_());
            ori = blockEntity;
            if (blockEntity == null) {
                return result;
            }
            if (ori.canBeRotated() && !this.blockType.hasCustomRotation()) {
                ori.setOrientation(forward, up);
            }
            if (blockEntity instanceof IOwnerAwareBlockEntity) {
                IOwnerAwareBlockEntity ownerAware = (IOwnerAwareBlockEntity)blockEntity;
                ownerAware.setOwner(player);
            }
        } else if (this.blockType instanceof IOrientableBlock) {
            ori.setOrientation(forward, up);
        }
        return result;
    }
}

