/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.config;

import appeng.core.config.ConfigSection;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ConfigFileManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private final ConfigSection rootSection;
    private final Path file;
    private boolean loading;

    public ConfigFileManager(ConfigSection rootSection, Path file) {
        this.rootSection = rootSection;
        this.file = file;
        rootSection.setChangeListener(() -> {
            if (!this.loading) {
                this.save();
            }
        });
    }

    public void load() {
        this.loading = true;
        try (BufferedReader reader2 = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
            JsonObject rootObj = (JsonObject)GSON.fromJson((Reader)reader2, JsonObject.class);
            this.rootSection.read(rootObj);
        }
        catch (FileNotFoundException reader2) {
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)e;
                throw runtimeException;
            }
            throw new RuntimeException("Failed to load AE2 config: " + this.file, e);
        }
        finally {
            this.loading = false;
        }
    }

    public void save() {
        if (this.file.getParent() != null) {
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create AE2 config directory: " + this.file.getParent());
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)this.rootSection.write(), (Appendable)writer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write AE2 config: " + this.file, e);
        }
        this.rootSection.write();
    }
}

