/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting;

import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.stacks.AEKey;
import appeng.crafting.CraftingLinkNexus;
import net.minecraft.nbt.CompoundTag;

public class CraftingLink
implements ICraftingLink {
    private final ICraftingRequester req;
    private final ICraftingCPU cpu;
    private final String CraftID;
    private final boolean standalone;
    private boolean canceled = false;
    private boolean done = false;
    private CraftingLinkNexus tie;

    public CraftingLink(CompoundTag data, ICraftingRequester req) {
        this.CraftID = data.m_128461_("CraftID");
        this.setCanceled(data.m_128471_("canceled"));
        this.setDone(data.m_128471_("done"));
        this.standalone = data.m_128471_("standalone");
        if (!data.m_128441_("req") || !data.m_128471_("req")) {
            throw new IllegalStateException("Invalid Crafting Link for Object");
        }
        this.req = req;
        this.cpu = null;
    }

    public CraftingLink(CompoundTag data, ICraftingCPU cpu) {
        this.CraftID = data.m_128461_("CraftID");
        this.setCanceled(data.m_128471_("canceled"));
        this.setDone(data.m_128471_("done"));
        this.standalone = data.m_128471_("standalone");
        if (!data.m_128441_("req") || data.m_128471_("req")) {
            throw new IllegalStateException("Invalid Crafting Link for Object");
        }
        this.cpu = cpu;
        this.req = null;
    }

    @Override
    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        if (this.done) {
            return false;
        }
        if (this.tie == null) {
            return false;
        }
        return this.tie.isCanceled();
    }

    @Override
    public boolean isDone() {
        if (this.done) {
            return true;
        }
        if (this.canceled) {
            return false;
        }
        if (this.tie == null) {
            return false;
        }
        return this.tie.isDone();
    }

    @Override
    public void cancel() {
        if (this.done) {
            return;
        }
        this.setCanceled(true);
        if (this.tie != null) {
            this.tie.cancel();
        }
        this.tie = null;
    }

    @Override
    public boolean isStandalone() {
        return this.standalone;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.m_128359_("CraftID", this.CraftID);
        tag.m_128379_("canceled", this.isCanceled());
        tag.m_128379_("done", this.isDone());
        tag.m_128379_("standalone", this.standalone);
        tag.m_128379_("req", this.getRequester() != null);
    }

    @Override
    public String getCraftingID() {
        return this.CraftID;
    }

    public void setNexus(CraftingLinkNexus n) {
        if (this.tie != null) {
            this.tie.remove(this);
        }
        if (this.isCanceled() && n != null) {
            n.cancel();
            this.tie = null;
            return;
        }
        this.tie = n;
        if (n != null) {
            n.add(this);
        }
    }

    public long insert(AEKey what, long amount, Actionable mode) {
        if (this.tie == null || this.tie.getRequest() == null || this.tie.getRequest().getRequester() == null) {
            return 0L;
        }
        if (this.tie.isCanceled()) {
            return 0L;
        }
        return this.tie.getRequest().getRequester().insertCraftedItems(this.tie.getRequest(), what, amount, mode);
    }

    public void markDone() {
        if (this.tie != null) {
            this.tie.markDone();
        }
    }

    void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    ICraftingRequester getRequester() {
        return this.req;
    }

    ICraftingCPU getCpu() {
        return this.cpu;
    }

    void setDone(boolean done) {
        this.done = done;
    }
}

