/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip;

import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.me.InWorldGridNode;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.service.TickManagerService;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class DebugProvider {
    private static final String TAG_NODES = "debugNodes";
    private static final String TAG_NODE_NAME = "nodeName";
    private static final String TAG_TICK_TIME = "tickTime";
    private static final String TAG_TICK_SLEEPING = "tickSleeping";
    private static final String TAG_TICK_ALERTABLE = "tickAlertable";
    private static final String TAG_TICK_AWAKE = "tickAwake";
    private static final String TAG_TICK_QUEUED = "tickQueued";
    private static final String TAG_TICK_CURRENT_RATE = "tickCurrentRate";
    private static final String TAG_TICK_LAST_TICK = "tickLastTick";
    private static final String TAG_NODE_EXPOSED = "exposedSides";

    private DebugProvider() {
    }

    public static void provideBlockEntityBody(BlockEntity object, TooltipContext context, TooltipBuilder tooltip) {
        Player player = context.player();
        if (!DebugProvider.isVisible(player)) {
            return;
        }
        DebugProvider.addBlockEntityRotation(object, tooltip);
        DebugProvider.addToTooltip(context.serverData(), tooltip);
    }

    public static void provideBlockEntityData(ServerPlayer player, BlockEntity object, CompoundTag serverData) {
        if (object instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity gridConnected = (IGridConnectedBlockEntity)object;
            if (DebugProvider.isVisible((Player)player)) {
                DebugProvider.addServerDataMainNode(serverData, gridConnected.getMainNode());
            }
        }
    }

    public static void providePartBody(AEBasePart object, TooltipContext context, TooltipBuilder tooltip) {
        DebugProvider.addToTooltip(context.serverData(), tooltip);
    }

    public static void providePartData(ServerPlayer player, AEBasePart part, CompoundTag serverData) {
        if (DebugProvider.isVisible((Player)player)) {
            DebugProvider.addServerDataMainNode(serverData, part.getMainNode());
            DebugProvider.addServerDataNode(serverData, "External Node", part.getExternalFacingNode());
        }
    }

    private static void addBlockEntityRotation(BlockEntity blockEntity, TooltipBuilder tooltip) {
        AEBaseBlockEntity be;
        if (blockEntity instanceof AEBaseBlockEntity && (be = (AEBaseBlockEntity)blockEntity).canBeRotated()) {
            Direction up = be.getUp();
            Direction forward = be.getForward();
            tooltip.addLine((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"Up: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)up.name())).m_7220_((Component)Component.m_237113_((String)" Forward: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)forward.name())));
        }
    }

    private static void addToTooltip(CompoundTag serverData, TooltipBuilder tooltip) {
        ListTag nodes = serverData.m_128437_(TAG_NODES, 10);
        for (Tag node : nodes) {
            CompoundTag nodeCompound = (CompoundTag)node;
            if (nodes.size() > 1) {
                String nodeName = ((CompoundTag)node).m_128461_(TAG_NODE_NAME);
                tooltip.addLine((Component)Component.m_237113_((String)nodeName).m_130940_(ChatFormatting.ITALIC));
            }
            DebugProvider.addNodeToTooltip(nodeCompound, tooltip);
        }
    }

    private static void addNodeToTooltip(CompoundTag tag, TooltipBuilder tooltip) {
        long[] tickTimes;
        if (tag.m_128425_(TAG_TICK_TIME, 12) && (tickTimes = tag.m_128467_(TAG_TICK_TIME)).length == 3) {
            long avg = tickTimes[0];
            long max = tickTimes[1];
            long sum = tickTimes[2];
            tooltip.addLine((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"Tick Time: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"Avg: ").m_130940_(ChatFormatting.ITALIC)).m_7220_((Component)Component.m_237113_((String)Platform.formatTimeMeasurement(avg)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" Max: ").m_130940_(ChatFormatting.ITALIC)).m_7220_((Component)Component.m_237113_((String)Platform.formatTimeMeasurement(max)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" Sum: ").m_130940_(ChatFormatting.ITALIC)).m_7220_((Component)Component.m_237113_((String)Platform.formatTimeMeasurement(sum)).m_130940_(ChatFormatting.WHITE)));
        }
        if (tag.m_128441_(TAG_TICK_QUEUED)) {
            ArrayList<String> status = new ArrayList<String>();
            if (tag.m_128471_(TAG_TICK_SLEEPING)) {
                status.add("Sleeping");
            }
            if (tag.m_128471_(TAG_TICK_ALERTABLE)) {
                status.add("Alertable");
            }
            if (tag.m_128471_(TAG_TICK_AWAKE)) {
                status.add("Awake");
            }
            if (tag.m_128471_(TAG_TICK_QUEUED)) {
                status.add("Queued");
            }
            tooltip.addLine((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"Tick Status: ").m_130940_(ChatFormatting.WHITE)).m_130946_(String.join((CharSequence)", ", status)));
            tooltip.addLine((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"Tick Rate: ").m_130940_(ChatFormatting.WHITE)).m_130946_(String.valueOf(tag.m_128451_(TAG_TICK_CURRENT_RATE))).m_7220_((Component)Component.m_237113_((String)" Last: ").m_130940_(ChatFormatting.WHITE)).m_130946_(tag.m_128451_(TAG_TICK_LAST_TICK) + " ticks ago"));
        }
        if (tag.m_128425_(TAG_NODE_EXPOSED, 3)) {
            int exposedSides = tag.m_128451_(TAG_NODE_EXPOSED);
            MutableComponent line = Component.m_237113_((String)"Node Exposed: ").m_130940_(ChatFormatting.WHITE);
            for (Direction value : Direction.values()) {
                MutableComponent sideText = Component.m_237113_((String)value.name().substring(0, 1));
                if ((exposedSides & 1 << value.ordinal()) == 0) {
                    sideText.m_130940_(ChatFormatting.GRAY);
                } else {
                    sideText.m_130940_(ChatFormatting.GREEN);
                }
                line.m_7220_((Component)sideText);
            }
            tooltip.addLine((Component)line);
        }
    }

    private static void addServerDataMainNode(CompoundTag tag, IManagedGridNode managedGridNode) {
        DebugProvider.addServerDataNode(tag, "Main Node", managedGridNode.getNode());
    }

    private static void addServerDataNode(CompoundTag tag, String name, @Nullable IGridNode node) {
        CompoundTag nodeTag = DebugProvider.toServerData(node, name);
        if (nodeTag != null) {
            ListTag nodes = (ListTag)tag.m_128423_(TAG_NODES);
            if (nodes == null) {
                nodes = new ListTag();
                tag.m_128365_(TAG_NODES, (Tag)nodes);
            }
            nodes.add((Object)nodeTag);
        }
    }

    private static CompoundTag toServerData(IGridNode node, String name) {
        if (node == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(TAG_NODE_NAME, name);
        if (node.getService(IGridTickable.class) != null) {
            TickManagerService tickManager = (TickManagerService)node.getGrid().getTickManager();
            long avg = tickManager.getAverageTime(node);
            long max = tickManager.getMaximumTime(node);
            long sum = tickManager.getOverallTime(node);
            tag.m_128388_(TAG_TICK_TIME, new long[]{avg, max, sum});
            TickManagerService.NodeStatus status = tickManager.getStatus(node);
            tag.m_128379_(TAG_TICK_SLEEPING, status.sleeping());
            tag.m_128379_(TAG_TICK_ALERTABLE, status.alertable());
            tag.m_128379_(TAG_TICK_AWAKE, status.awake());
            tag.m_128379_(TAG_TICK_QUEUED, status.queued());
            tag.m_128405_(TAG_TICK_CURRENT_RATE, status.currentRate());
            tag.m_128356_(TAG_TICK_LAST_TICK, status.lastTick());
        }
        if (node instanceof InWorldGridNode) {
            int exposedSides = 0;
            for (Direction value : Direction.values()) {
                if (!node.isExposedOnSide(value)) continue;
                exposedSides |= 1 << value.ordinal();
            }
            tag.m_128405_(TAG_NODE_EXPOSED, exposedSides);
        }
        return tag;
    }

    private static boolean isVisible(Player player) {
        return AEItems.DEBUG_CARD.isSameAs(player.m_21120_(InteractionHand.OFF_HAND)) || AEItems.DEBUG_CARD.isSameAs(player.m_21120_(InteractionHand.MAIN_HAND));
    }
}

