/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.Icon;
import appeng.core.AELog;
import appeng.menu.AEBaseMenu;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AppEngSlot
extends Slot {
    private static final Container EMPTY_INVENTORY = new SimpleContainer(0);
    private final InternalInventory inventory;
    private final int invSlot;
    private boolean hideAmount;
    private boolean isEnabled = true;
    @Nullable
    private List<Component> emptyTooltip;
    private boolean isDraggable = true;
    private AEBaseMenu menu = null;
    private boolean active = true;
    @Nullable
    private Icon icon;
    private Boolean validState = null;

    public AppEngSlot(InternalInventory inv, int invSlot) {
        super(EMPTY_INVENTORY, invSlot, 0, 0);
        this.inventory = inv;
        this.invSlot = invSlot;
    }

    public Slot setNotDraggable() {
        this.setDraggable(false);
        return this;
    }

    public void clearStack() {
        this.inventory.setItemDirect(this.invSlot, ItemStack.f_41583_);
    }

    @Nullable
    public List<Component> getCustomTooltip(Function<ItemStack, List<Component>> getItemTooltip, ItemStack carriedItem) {
        if (this.getDisplayStack().m_41619_() && this.emptyTooltip != null) {
            return this.emptyTooltip;
        }
        return null;
    }

    public boolean m_5857_(ItemStack stack) {
        if (this.containsWrapperItem()) {
            return false;
        }
        if (this.isSlotEnabled()) {
            return this.inventory.isItemValid(this.invSlot, stack);
        }
        return false;
    }

    public ItemStack m_7993_() {
        if (!this.isSlotEnabled()) {
            return ItemStack.f_41583_;
        }
        if (this.f_40217_ >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        return this.inventory.getStackInSlot(this.invSlot);
    }

    public void m_5852_(ItemStack stack) {
        if (this.isSlotEnabled()) {
            this.inventory.setItemDirect(this.invSlot, stack);
            this.m_6654_();
        }
    }

    public void m_219996_(ItemStack stack) {
        if (!this.isSlotEnabled() && this.invSlot >= this.inventory.size() && stack.m_41619_()) {
            return;
        }
        this.inventory.setItemDirect(this.invSlot, stack);
    }

    private void notifyContainerSlotChanged() {
        if (this.getMenu() != null) {
            this.getMenu().onSlotChange(this);
        }
    }

    public InternalInventory getInventory() {
        return this.inventory;
    }

    public void m_6654_() {
        super.m_6654_();
        this.validState = null;
        this.notifyContainerSlotChanged();
    }

    public int m_6641_() {
        return this.inventory.getSlotLimit(this.invSlot);
    }

    public int m_5866_(ItemStack stack) {
        return Math.min(this.m_6641_(), stack.m_41741_());
    }

    public boolean m_8010_(Player player) {
        if (this.containsWrapperItem()) {
            return false;
        }
        if (this.isSlotEnabled()) {
            return !this.inventory.extractItem(this.invSlot, 1, true).m_41619_();
        }
        return false;
    }

    public ItemStack m_6201_(int amount) {
        if (this.containsWrapperItem()) {
            return ItemStack.f_41583_;
        }
        return this.inventory.extractItem(this.invSlot, amount, false);
    }

    private boolean containsWrapperItem() {
        return GenericStack.isWrapped(this.m_7993_());
    }

    public boolean isSameInventory(Slot other) {
        return other instanceof AppEngSlot && ((AppEngSlot)other).inventory == this.inventory;
    }

    public InternalInventory getSlotInv() {
        return this.inventory.getSlotInv(this.invSlot);
    }

    public boolean m_6659_() {
        return this.isSlotEnabled() && this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isSlotEnabled() {
        return this.isEnabled;
    }

    public void setSlotEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public ItemStack getDisplayStack() {
        ItemStack is = this.m_7993_();
        if (this.hideAmount) {
            GenericStack unwrapped = GenericStack.unwrapItemStack(is);
            if (unwrapped != null) {
                return GenericStack.wrapInItemStack(unwrapped.what(), 0L);
            }
            is = is.m_41777_();
            is.m_41764_(1);
        }
        return is;
    }

    public float getOpacityOfIcon() {
        return 0.4f;
    }

    public boolean renderIconWithItem() {
        return false;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    private void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    protected AEBaseMenu getMenu() {
        return this.menu;
    }

    public void setMenu(AEBaseMenu menu) {
        this.menu = menu;
    }

    protected boolean isRemote() {
        return this.menu == null || this.menu.isClientSide();
    }

    public final boolean isValid() {
        if (this.validState == null) {
            try {
                this.validState = this.getCurrentValidationState();
            }
            catch (Exception e) {
                this.validState = false;
                AELog.warn("Failed to update validation state for slot %s: %s", new Object[]{this, e});
            }
        }
        return this.validState;
    }

    protected boolean getCurrentValidationState() {
        return true;
    }

    public void resetCachedValidation() {
        this.validState = null;
    }

    public boolean isHideAmount() {
        return this.hideAmount;
    }

    public void setHideAmount(boolean hideAmount) {
        this.hideAmount = hideAmount;
    }

    @Nullable
    public List<Component> getEmptyTooltip() {
        return this.emptyTooltip;
    }

    public void setEmptyTooltip(@Nullable List<Component> emptyTooltip) {
        this.emptyTooltip = emptyTooltip;
    }
}

