/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.helpers.ICustomNameObject;
import appeng.items.tools.MemoryCardItem;
import appeng.util.CustomNameUtil;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class AEBasePart
implements IPart,
IActionHost,
ICustomNameObject,
ISegmentedInventory,
IPowerChannelState {
    private final IManagedGridNode mainNode;
    private IPartItem<?> partItem;
    private BlockEntity blockEntity = null;
    private IPartHost host = null;
    @Nullable
    private Direction side;
    @Nullable
    private Component customName;
    private boolean clientSidePowered;
    private boolean clientSideMissingChannel;

    public AEBasePart(IPartItem<?> partItem) {
        this.partItem = Objects.requireNonNull(partItem, "partItem");
        this.mainNode = this.createMainNode().setVisualRepresentation(AEItemKey.of(this.partItem)).setExposedOnSides(EnumSet.noneOf(Direction.class));
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode(this, NodeListener.INSTANCE);
    }

    @MustBeInvokedByOverriders
    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.markForUpdateIfClientFlagsChanged();
        }
    }

    public final boolean isClientSide() {
        return this.blockEntity == null || this.blockEntity.m_58904_() == null || this.blockEntity.m_58904_().m_5776_();
    }

    public IPartHost getHost() {
        return this.host;
    }

    protected AEColor getColor() {
        if (this.host == null) {
            return AEColor.TRANSPARENT;
        }
        return this.host.getColor();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    @Override
    public IGridNode getActionableNode() {
        return this.mainNode.getNode();
    }

    public final BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public Level getLevel() {
        return this.blockEntity.m_58904_();
    }

    @Override
    public Component getCustomInventoryName() {
        return (Component)Objects.requireNonNullElse(this.customName, Component.m_237119_());
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null;
    }

    @Override
    public void addEntityCrashInfo(CrashReportCategory crashreportcategory) {
        crashreportcategory.m_128159_("Part Side", (Object)this.getSide());
        BlockEntity beHost = this.getBlockEntity();
        if (beHost != null) {
            beHost.m_58886_(crashreportcategory);
            Level level = beHost.m_58904_();
            if (level != null) {
                crashreportcategory.m_128159_("Level", (Object)level.m_46472_());
            }
        }
    }

    @Override
    public IPartItem<?> getPartItem() {
        return this.partItem;
    }

    protected void setPartItem(IPartItem<?> partItem) {
        if (partItem != this.partItem) {
            this.partItem = Objects.requireNonNull(partItem);
            this.getMainNode().setVisualRepresentation(partItem);
        }
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        this.mainNode.loadFromNBT(data);
        if (data.m_128441_("customName")) {
            try {
                this.customName = Component.Serializer.m_130701_((String)data.m_128461_("customName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (data.m_128425_("visual", 10)) {
            this.readVisualStateFromNBT(data.m_128469_("visual"));
        }
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        this.mainNode.saveToNBT(data);
        if (this.customName != null) {
            data.m_128359_("customName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void writeToStream(FriendlyByteBuf data) {
        this.clientSidePowered = this.isPowered();
        this.clientSideMissingChannel = this.isMissingChannel();
        int flags = 0;
        if (this.clientSidePowered) {
            flags |= 1;
        }
        if (this.clientSideMissingChannel) {
            flags |= 2;
        }
        data.writeByte(flags);
    }

    @Override
    @MustBeInvokedByOverriders
    public boolean readFromStream(FriendlyByteBuf data) {
        byte flags = data.readByte();
        boolean wasPowered = this.clientSidePowered;
        boolean wasMissingChannel = this.clientSideMissingChannel;
        this.clientSidePowered = (flags & 1) != 0;
        this.clientSideMissingChannel = (flags & 2) != 0;
        return this.shouldSendPowerStateToClient() && this.clientSidePowered != wasPowered || this.shouldSendMissingChannelStateToClient() && this.clientSideMissingChannel != wasMissingChannel;
    }

    @Override
    @MustBeInvokedByOverriders
    public void writeVisualStateToNBT(CompoundTag data) {
        data.m_128379_("powered", this.isPowered());
        data.m_128379_("missingChannel", this.isMissingChannel());
    }

    @Override
    @MustBeInvokedByOverriders
    public void readVisualStateFromNBT(CompoundTag data) {
        this.clientSidePowered = data.m_128471_("powered");
        this.clientSideMissingChannel = data.m_128471_("missingChannel");
    }

    @Override
    public IGridNode getGridNode() {
        return this.mainNode.getNode();
    }

    @Override
    public void removeFromWorld() {
        this.mainNode.destroy();
    }

    @Override
    public void addToWorld() {
        this.mainNode.create(this.getLevel(), this.blockEntity.m_58899_());
    }

    @Override
    public void setPartHostInfo(Direction side, IPartHost host, BlockEntity blockEntity) {
        this.setSide(side);
        this.blockEntity = blockEntity;
        this.host = host;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 3.0f;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        this.customName = CustomNameUtil.getCustomName(input);
        MemoryCardItem.importGenericSettings(this, input, player);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void exportSettings(SettingsFrom mode, CompoundTag output) {
        CustomNameUtil.setCustomName(output, this.customName);
        if (mode == SettingsFrom.MEMORY_CARD) {
            MemoryCardItem.exportGenericSettings(this, output);
        }
    }

    public boolean useStandardMemoryCard() {
        return true;
    }

    private boolean useMemoryCard(Player player) {
        Item item;
        ItemStack memCardIS = player.m_150109_().m_36056_();
        if (!memCardIS.m_41619_() && this.useStandardMemoryCard() && (item = memCardIS.m_41720_()) instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)item;
            Object partItem = this.getPartItem().m_5456_();
            if (AEParts.INTERFACE.m_5456_() == partItem) {
                partItem = AEBlocks.INTERFACE.m_5456_();
            } else if (AEParts.PATTERN_PROVIDER.m_5456_() == partItem) {
                partItem = AEBlocks.PATTERN_PROVIDER.m_5456_();
            }
            String name = partItem.m_5524_();
            if (InteractionUtil.isInAlternateUseMode(player)) {
                CompoundTag data = new CompoundTag();
                this.exportSettings(SettingsFrom.MEMORY_CARD, data);
                if (!data.m_128456_()) {
                    memoryCard.setMemoryCardContents(memCardIS, name, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                }
            } else {
                String storedName = memoryCard.getSettingsName(memCardIS);
                CompoundTag data = memoryCard.getData(memCardIS);
                if (name.equals(storedName)) {
                    this.importSettings(SettingsFrom.MEMORY_CARD, data, player);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                } else {
                    MemoryCardItem.importGenericSettingsAndNotify(this, data, player);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean onActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartActivate(player, hand, pos);
    }

    @Override
    public final boolean onShiftActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartShiftActivate(player, hand, pos);
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        return false;
    }

    public boolean onPartShiftActivate(Player player, InteractionHand hand, Vec3 pos) {
        return false;
    }

    @Override
    public void onPlacement(Player player) {
        this.mainNode.setOwningPlayer(player);
    }

    public Direction getSide() {
        return this.side;
    }

    private void setSide(Direction side) {
        this.side = side;
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public InternalInventory getSubInventory(ResourceLocation id) {
        return null;
    }

    @Override
    public boolean isPowered() {
        if (this.isClientSide()) {
            return this.clientSidePowered;
        }
        IGridNode node = this.getGridNode();
        return node != null && node.isPowered();
    }

    public boolean isMissingChannel() {
        if (this.isClientSide()) {
            return this.clientSideMissingChannel;
        }
        IGridNode node = this.getGridNode();
        return node == null || !node.meetsChannelRequirements();
    }

    @Override
    public boolean isActive() {
        return this.isPowered() && !this.isMissingChannel();
    }

    private void markForUpdateIfClientFlagsChanged() {
        boolean changed = false;
        if (this.shouldSendPowerStateToClient() && this.isPowered() != this.clientSidePowered) {
            changed = true;
        }
        if (!changed && this.shouldSendMissingChannelStateToClient() && this.isMissingChannel() != this.clientSideMissingChannel) {
            changed = true;
        }
        if (changed) {
            this.getHost().markForUpdate();
        }
    }

    protected boolean shouldSendPowerStateToClient() {
        return true;
    }

    protected boolean shouldSendMissingChannelStateToClient() {
        return true;
    }

    public static class NodeListener<T extends AEBasePart>
    implements IGridNodeListener<T> {
        public static final NodeListener<AEBasePart> INSTANCE = new NodeListener();

        @Override
        public void onSecurityBreak(T nodeOwner, IGridNode node) {
            if (((AEBasePart)nodeOwner).getHost().getPart(((AEBasePart)nodeOwner).getSide()) == nodeOwner) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                nodeOwner.addPartDrop(items, false);
                nodeOwner.addAdditionalDrops(items, false);
                ((AEBasePart)nodeOwner).getHost().removePartFromSide(((AEBasePart)nodeOwner).getSide());
                if (!items.isEmpty()) {
                    BlockEntity be = ((AEBasePart)nodeOwner).getHost().getBlockEntity();
                    Platform.spawnDrops(be.m_58904_(), be.m_58899_(), items);
                }
            }
        }

        @Override
        public void onSaveChanges(T nodeOwner, IGridNode node) {
            ((AEBasePart)nodeOwner).getHost().markForSave();
        }

        @Override
        public void onStateChanged(T nodeOwner, IGridNode node, IGridNodeListener.State state) {
            ((AEBasePart)nodeOwner).onMainNodeStateChanged(state);
        }
    }
}

