/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.parts.AEBasePart;
import appeng.util.BlockApiCache;
import appeng.util.Platform;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;

public class PartAdjacentApi<C> {
    private final AEBasePart part;
    private final Capability<C> apiLookup;
    private BlockApiCache<C> apiCache;

    public PartAdjacentApi(AEBasePart part, Capability<C> apiLookup) {
        this.apiLookup = apiLookup;
        this.part = part;
    }

    @Nullable
    public C find() {
        Level level = this.part.getLevel();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockEntity host = this.part.getHost().getBlockEntity();
        Direction attachedSide = this.part.getSide();
        BlockPos targetPos = host.m_58899_().m_121945_(attachedSide);
        if (!Platform.areBlockEntitiesTicking((Level)serverLevel, targetPos)) {
            return null;
        }
        if (this.apiCache == null) {
            this.apiCache = BlockApiCache.create(this.apiLookup, serverLevel, targetPos);
        }
        return this.apiCache.find(attachedSide.m_122424_());
    }
}

