/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.ManualScreenStyle;
import li.cil.manual.api.ManualStyle;
import li.cil.manual.api.Tab;
import li.cil.manual.api.content.Document;
import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.segment.InteractiveSegment;
import li.cil.manual.client.util.IterableUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public final class ManualScreen
extends Screen {
    private final ManualModel model;
    private final ManualStyle manualStyle;
    private final ManualScreenStyle screenStyle;
    private final DocumentRenderer documentRenderer;
    private String currentPath;
    private int leftPos = 0;
    private int topPos = 0;
    private float scrollPos = 0.0f;
    private boolean isDragging = false;
    private int documentHeight = 0;
    private Optional<InteractiveSegment> currentSegment = Optional.empty();
    private ScrollButton scrollButton = null;

    public ManualScreen(ManualModel model, ManualStyle manualStyle, ManualScreenStyle screenStyle) {
        super((Component)Component.m_237113_((String)"Manual"));
        this.model = model;
        this.manualStyle = manualStyle;
        this.screenStyle = screenStyle;
        this.documentRenderer = new DocumentRenderer(model, manualStyle);
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.screenStyle.getWindowRect().m_110090_()) / 2 + this.screenStyle.getWindowRect().m_110085_();
        this.topPos = (this.f_96544_ - this.screenStyle.getWindowRect().m_110091_()) / 2 + this.screenStyle.getWindowRect().m_110086_();
        IterableUtils.forEachWithIndex(this.model.getTabs(), (i, tab) -> {
            int x = this.screenStyle.getTabAreaRect().m_110085_();
            int y = this.screenStyle.getTabAreaRect().m_110086_() + i * this.getTabClickableHeight();
            if (y + this.screenStyle.getTabRect().m_110091_() > this.screenStyle.getTabAreaRect().m_110091_()) {
                return;
            }
            this.m_142416_((GuiEventListener)new TabButton(this.leftPos + x, this.topPos + y, (Tab)tab, button -> this.pushManualPage((Tab)tab)));
        });
        this.scrollButton = (ScrollButton)this.m_142416_((GuiEventListener)new ScrollButton(this.leftPos + this.screenStyle.getScrollBarRect().m_110085_() + this.screenStyle.getScrollButtonRect().m_110085_(), this.topPos + this.screenStyle.getScrollBarRect().m_110086_() + this.screenStyle.getScrollButtonRect().m_110086_(), this.screenStyle.getScrollButtonRect().m_110090_(), this.screenStyle.getScrollButtonRect().m_110091_()));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        if (!Objects.equals(this.currentPath, this.model.peek())) {
            this.refreshPage();
            this.currentPath = this.model.peek();
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.manualStyle.getPageChangeSound(), (float)1.0f));
        }
        this.scrollPos = Mth.m_14179_((float)(partialTicks * 0.5f), (float)this.scrollPos, (float)this.getScrollPosition());
        RenderSystem.m_69478_();
        this.scrollButton.f_93623_ = false;
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.screenStyle.getWindowBackground());
        Rect2i windowRect = this.screenStyle.getWindowRect();
        ManualScreen.m_93133_((PoseStack)matrixStack, (int)this.leftPos, (int)this.topPos, (float)0.0f, (float)0.0f, (int)windowRect.m_110090_(), (int)windowRect.m_110091_(), (int)windowRect.m_110090_(), (int)windowRect.m_110091_());
        this.scrollButton.f_93623_ = this.canScroll();
        this.scrollButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        Rect2i documentRect = this.screenStyle.getDocumentRect();
        int documentX = this.leftPos + documentRect.m_110085_();
        int documentY = this.topPos + documentRect.m_110086_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)documentX, (double)documentY, 0.0);
        this.currentSegment = this.documentRenderer.render(matrixStack, this.getSmoothScrollPosition(), documentRect.m_110090_(), documentRect.m_110091_(), mouseX - documentX, mouseY - documentY);
        matrixStack.m_85849_();
        this.currentSegment.flatMap(InteractiveSegment::getTooltip).ifPresent(t -> this.m_96597_(matrixStack, Collections.singletonList(t), mouseX, mouseY));
        for (GuiEventListener widget : this.m_6702_()) {
            if (!(widget instanceof AbstractWidget)) continue;
            AbstractWidget button = (AbstractWidget)widget;
            if (!button.f_93623_ || this.isDragging && widget != this.scrollButton) continue;
            button.m_7428_(matrixStack, mouseX, mouseY);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        this.scrollBy(delta);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Minecraft mc = Objects.requireNonNull(this.f_96541_);
        if (mc.f_91066_.f_92089_.m_90832_(keyCode, scanCode)) {
            this.popManualPage();
            return true;
        }
        if (mc.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                player.m_6915_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll() && button == 0 && this.isCoordinateOverScrollBar(mouseX, mouseY)) {
            this.isDragging = true;
            this.scrollButton.m_7435_(Minecraft.m_91087_().m_91106_());
            this.scrollTo(mouseY);
            return true;
        }
        if (button == 0) {
            return this.currentSegment.map(InteractiveSegment::mouseClicked).orElse(false);
        }
        if (button == 1) {
            this.popManualPage();
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.isDragging) {
            this.scrollTo(mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        super.m_6348_(mouseX, mouseY, button);
        if (button == 0) {
            this.isDragging = false;
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private void pushManualPage(Tab tab) {
        this.model.push(tab.getPath());
    }

    private void popManualPage() {
        if (!this.model.pop()) {
            this.m_7379_();
        }
    }

    private boolean canScroll() {
        return this.maxScrollPosition() > 0;
    }

    private int getScrollPosition() {
        return this.model.getUserData(ScrollOffset.class).map(offset -> offset.value).orElse(0);
    }

    private void setScrollPosition(int value) {
        this.model.setUserData(new ScrollOffset(value));
    }

    private int maxScrollPosition() {
        return Math.max(0, this.documentHeight - this.screenStyle.getDocumentRect().m_110091_());
    }

    private void refreshPage() {
        Optional<Document> document = this.model.documentFor(this.model.peek());
        this.documentRenderer.parse(document.orElse(new Document(Collections.singletonList("Page not found: " + this.model.peek()))));
        this.documentHeight = this.documentRenderer.height(this.screenStyle.getDocumentRect().m_110090_());
        this.scrollPos = this.getScrollPosition() - this.manualStyle.getLineHeight() * 3;
    }

    private void scrollTo(double mouseY) {
        int scrollButtonHeight = this.screenStyle.getScrollButtonRect().m_110091_();
        int halfScrollButtonHeight = (int)Math.ceil((double)scrollButtonHeight * 0.5);
        int scrollMinY = this.topPos + this.screenStyle.getScrollBarRect().m_110086_() + halfScrollButtonHeight;
        int scrollHeight = this.screenStyle.getScrollBarRect().m_110091_() - scrollButtonHeight;
        int localMouseY = (int)(mouseY - (double)scrollMinY);
        this.scrollTo(this.maxScrollPosition() * localMouseY / scrollHeight, true);
    }

    private void scrollBy(double amount) {
        this.scrollTo(this.getScrollPosition() - (int)Math.round((double)(this.manualStyle.getLineHeight() * 3) * amount), false);
    }

    private void scrollTo(int y, boolean immediate) {
        this.setScrollPosition(Math.max(0, Math.min(this.maxScrollPosition(), y)));
        if (immediate) {
            this.scrollPos = this.getScrollPosition();
        }
    }

    private int getSmoothScrollPosition() {
        if (this.scrollPos < (float)this.getScrollPosition()) {
            return (int)Math.ceil(this.scrollPos);
        }
        return (int)Math.floor(this.scrollPos);
    }

    private int getScrollButtonY() {
        if (this.maxScrollPosition() > 0) {
            int yMax = this.screenStyle.getScrollBarRect().m_110091_() - this.screenStyle.getScrollButtonRect().m_110091_();
            return Math.max(0, Math.min(yMax, yMax * this.getSmoothScrollPosition() / this.maxScrollPosition()));
        }
        return 0;
    }

    private boolean isCoordinateOverScrollBar(double x, double y) {
        return this.screenStyle.getScrollBarRect().m_110087_((int)(x - (double)this.leftPos), (int)(y - (double)this.topPos));
    }

    private int getTabClickableHeight() {
        return this.screenStyle.getTabRect().m_110091_() - this.screenStyle.getTabOverlap();
    }

    private class ScrollButton
    extends Button {
        private static final int TOOLTIP_HEIGHT = 18;
        private final int baseY;

        ScrollButton(int x, int y, int w, int h) {
            super(x, y, w, h, (Component)Component.m_237119_(), button -> {});
            this.baseY = y;
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            if (super.m_93680_(mouseX, mouseY)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
            }
            return false;
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.f_93621_ = this.baseY + ManualScreen.this.getScrollButtonY();
            int x0 = this.f_93620_;
            int x1 = x0 + this.f_93618_;
            int y0 = this.f_93621_;
            int y1 = y0 + this.f_93619_;
            float u0 = 0.0f;
            float u1 = 1.0f;
            float v0 = ManualScreen.this.isDragging || this.m_198029_() ? 0.5f : 0.0f;
            float v1 = v0 + 0.5f;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ManualScreen.this.screenStyle.getScrollButtonTexture());
            Tesselator t = Tesselator.m_85913_();
            BufferBuilder builder = t.m_85915_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            builder.m_5483_((double)x0, (double)y1, (double)this.m_93252_()).m_7421_(0.0f, v1).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)this.m_93252_()).m_7421_(1.0f, v1).m_5752_();
            builder.m_5483_((double)x1, (double)y0, (double)this.m_93252_()).m_7421_(1.0f, v0).m_5752_();
            builder.m_5483_((double)x0, (double)y0, (double)this.m_93252_()).m_7421_(0.0f, v0).m_5752_();
            t.m_85914_();
        }

        public void m_7428_(PoseStack matrixStack, int mouseX, int mouseY) {
            if (!(ManualScreen.this.isDragging || this.m_198029_() || ManualScreen.this.isCoordinateOverScrollBar(mouseX, mouseY))) {
                return;
            }
            ManualScreen.this.m_96602_(matrixStack, (Component)Component.m_237113_((String)(100 * ManualScreen.this.getScrollPosition() / ManualScreen.this.maxScrollPosition() + "%")), ManualScreen.this.leftPos + ManualScreen.this.screenStyle.getScrollBarRect().m_110085_() + ManualScreen.this.screenStyle.getScrollBarRect().m_110090_(), this.f_93621_ + (this.m_93694_() + 18) / 2);
        }
    }

    private record ScrollOffset(int value) {
    }

    private class TabButton
    extends Button {
        private final Tab tab;
        private final int baseX;
        private float currentX;
        private int targetX;

        TabButton(int x, int y, Tab tab, Button.OnPress action) {
            super(x, y, ManualScreen.this.screenStyle.getTabRect().m_110090_(), ManualScreen.this.getTabClickableHeight(), (Component)Component.m_237119_(), action);
            this.tab = tab;
            this.baseX = x;
            this.currentX = x + ManualScreen.this.screenStyle.getTabHoverShift();
            this.targetX = (int)this.currentX;
        }

        public void m_7428_(PoseStack matrixStack, int mouseX, int mouseY) {
            if (!this.m_198029_()) {
                return;
            }
            ArrayList<Component> tooltip = new ArrayList<Component>();
            this.tab.getTooltip(tooltip);
            if (!tooltip.isEmpty()) {
                ManualScreen.this.m_96597_(matrixStack, tooltip, mouseX, mouseY);
            }
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.targetX = this.m_198029_() ? this.baseX : this.baseX + ManualScreen.this.screenStyle.getTabHoverShift();
            this.currentX = Mth.m_14179_((float)(partialTicks * 0.5f), (float)this.currentX, (float)this.targetX);
            this.f_93620_ = this.currentX < (float)this.targetX ? (int)Math.ceil(this.currentX) : (int)Math.floor(this.currentX);
            this.f_93618_ = ManualScreen.this.screenStyle.getTabAreaRect().m_110090_() - (this.f_93620_ - this.baseX);
            int v0 = this.m_198029_() ? ManualScreen.this.screenStyle.getTabRect().m_110091_() : 0;
            int visualWidth = ManualScreen.this.screenStyle.getTabRect().m_110090_();
            int visualHeight = ManualScreen.this.screenStyle.getTabRect().m_110091_();
            int textureWidth = ManualScreen.this.screenStyle.getTabRect().m_110090_();
            int textureHeight = ManualScreen.this.screenStyle.getTabRect().m_110091_() * 2;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ManualScreen.this.screenStyle.getTabButtonTexture());
            TabButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)v0, (int)visualWidth, (int)visualHeight, (int)textureWidth, (int)textureHeight);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(this.f_93620_ + 12), (double)(this.f_93621_ + (ManualScreen.this.screenStyle.getTabRect().m_110091_() - 18) / 2), 0.0);
            this.tab.renderIcon(matrixStack);
            matrixStack.m_85849_();
        }

        public void m_7435_(SoundManager soundHandler) {
        }
    }
}

