# Руководство TIS-3D

"Машина Tessellated Intelligence System (Тесселированная Система Анализа) имеет в своей основе многопроцессорную вычислительную архитектуру, состоящую из неравномерно взаимосвязанных разнородных узлов. TIS идеально подходит для приложений, требующих потоковой обработки комплексных данных, например, автоматизированной валютной торговли, сбора массивов данных или анализа поведения граждан." - *Руководство TIS-100*

TIS-3D - это трёхмерная интерпретация дизайна TIS. Её цель состоит в том, чтобы позволить управлять другими машинами и механизмами в мире, которые в противном случае могли бы потребовать сложных схем из красного камня. Или просто представить собой интересную задачу!

## Спецификация компьютера
TIS-3D позволяет строить мощные модульные компьютеры. Компьютер состоит ровно из одного [контроллера](block/controller.md) и до восьми [корпусов](block/casing.md). Контроллер и [корпуса](block/casing.md) соединяются общей стороной. Соединение с [контроллером](block/controller.md) переходно: если [корпус](block/casing.md) `C1` соединён с [контроллером](block/controller.md), [корпус](block/casing.md) `C2` также соединяется с [контроллером](block/controller.md), если он соединён с [корпусом](block/casing.md) `C1`.

Компьютер должен иметь ровно один [контроллер](block/controller.md). Если подключены несколько [контроллеров](block/controller.md), прямо или косвенно, компьютер не включится. Компьютер должен иметь не более восьми [корпусов](block/casing.md). Если к [контроллеру](block/controller.md) подключено более восьми [корпусов](block/casing.md), компьютер не включится.

Чтобы включить компьютер, подайте сигнал красного камня к любой стороне [контроллера](block/controller.md). Скорость работы компьютера регулируется силой подаваемого сигнала. Применение нескольких сигналов красного камня к одному [контроллеру](block/controller.md) приводит к неопределённому поведению. Обратитесь к производителю вашего [контроллера](block/controller.md) за спецификацией, так как это может привести к аннулированию гарантии. Предоставление минимального количества энергии приостанавливает работу компьютера. Выключение компьютера полностью сбрасывает его состояние.

## Спецификация модуля
[Корпус](block/casing.md) вмещает до шести [модулей](item/index.md), каждый из которых может быть размещён на одной из сторон [корпуса](block/casing.md). Каждый [модуль](item/index.md) имеет до четырёх локальных соединений с соседними [модулями](item/index.md), по одному для каждого края [модуля](item/index.md): `up`, `right`, `down` и `left`. Эти порты позволяют [модулям](item/index.md) взаимодействовать путём чтения и записи отдельных значений.

Каждая операция чтения/записи является блокирующей операцией. [Модуль](item/index.md), выполняющий операцию, обычно блокируется, пока операция не будет завершена. *Могут существовать исключения для конкретных производителей*. Если два [модуля](item/index.md) начинают операцию чтения с одного и того же общего порта, они входят в тупик. Если [модуль](item/index.md) выполняет запись в порт на стороне, где нет другого [модуля](item/index.md), он входит в тупик. Чтобы выйти из тупика, перезагрузите компьютер. "Горячая" замена [модулей](item/index.md) технически возможна, но обычно приводит к нежелательным результатам.
