# Модуль дисплея

![Раскраска по номерам](item:tis3d:display_module)

Модуль дисплея обеспечивает очень гибкий метод визуализации произвольных данных в виде двумерной сетки цветных ячеек (*Примечание редактора*: "пиксели", как дети любят их называть). Цвет этих ячеек можно изменить, указав последовательность чисел на любой из четырех портов модуля дисплея, содержащую цветовой код, а также положение и размер прямоугольника для заполнения.

Модуль дисплея непрерывно считывает значения со всех четырёх своих портов и накапливает по пять значений на один вызов отрисовки. После получения всех пяти значений, необходимых для вызова отрисовки, заданный прямоугольник накладывается на цветовую сетке.

## Спецификация вызова отрисовки
Каждая последовательность из пяти полученных модулем дисплея значений интерпретируется как вызов отрисовки из компонентов: цвет, столбец, строка, ширина и высота. Сетка является квадратной и имеет по двадцать восемь (28) столбцов и рядов. Значения цвета берутся из фиксированной палитры. Точные значения цвета могут варьироваться в зависимости от производителя, однако общие названия цветов соответствуют физическому спектру этого мира:
- `0`: Белый
- `1`: Оранжевый
- `2`: Сиреневый
- `3`: Светло-синий
- `4`: Жёлтый
- `5`: Лаймовый
- `6`: Розовый
- `7`: Серый
- `8`: Светло-серый
- `9`: Бирюзовый
- `10`: Фиолетовый
- `11`: Синий
- `12`: Коричневый
- `13`: Зелёный
- `14`: Красный
- `15`: Чёрный

Предоставление недопустимых значений либо для цвета, либо для координат ведёт к неопределённому поведениею, но, как правило, оно должно обрабатываться по усмотрению производителя.

Простая программа рисования вертикальных линий разными цветами:
`MOV 16 ACC`
`LOOP:`
`SUB 1`
`MOV ACC LEFT # COLOR`
`MOV ACC LEFT # X`
`MOV 0 LEFT # Y`
`MOV 1 LEFT # WIDTH`
`MOV 28 LEFT # HEIGHT`
`JNZ LOOP`