# Модуль выполнения

![Выыыыполнить!](item:tis3d:execution_module)

Модуль выполнения является основным средством программирования компьютера TIS-3D. После установки в [корпус](../block/casing.md) его можно запрограммировать, используя для этого книгу, содержащую код для его программирования.

## Архитектура
Модуль выполнения позволяет пользователю с большой гибкостью управлять работой компьютера TIS-3D. Каждый модуль выполнения может быть запрограммирован с использованием примитивного языка ассемблера, обеспечивающего оптимизированный набор инструкций. Будучи активным, модуль выполнения обрабатывает запрограммированные инструкции одну за другой, начиная с первой инструкции в программе. Все инструкции, которые не являются командами перехода, переводят счётчик программы к следующей инструкции в программе после завершения их работы. Если счётчик программы покидает допустимый диапазон команд, программа автоматически продолжает выполнение с первой инструкции. *Это прямо подразумевает, что программы зацикливаются*, если явно не остановлены.

Инструкции могут действовать на цели различных видов. Цель - это допустимый источник для чтения значения из него или приёмник для записи значения в него. Допустимые цели включают четыре порта модуля выполнения, регистры модуля выполнения и небольшое количество виртуальных регистров и портов.

Компьютер TIS-3D и, в частности, модуль выполнения поддерживают 16-битный диапазон значений, который обрабатывается как одиночное значение со знаком в диапазоне от -32768 до 32767. *Из-за технических ограничений некоторые модули, включая модуль выполнения, могут отображать значения в виде шестнадцатеричных представлений без знака*.

## Цели
`ACC`
Регистр. Это основной регистр модуля выполнения. Арифметические операции обычно сохраняют свои результаты в этом регистре.

`BAK`
Неадресуемый регистр. Специальный регистр, который можно использовать для хранения значения из `ACC`. Он не может быть адресован напрямую, а должен быть доступен с помощью инструкций `SAV` и `SWP`.

`NIL`
Виртуальный регистр. Это псевдоцель, которая может быть записана для удаления значений или считана для получения нулевых значений.

`LEFT`, `RIGHT`, `UP`, `DOWN`
Порт. Они представляют собой четыре порта модуля выполнения. Работа с внешними портами обычно медленнее, чем с внутренними регистрами.

`ANY`
Виртуальный порт. Это псевдоцель, которая будет выполнять операцию на всех портах одновременно, но фактически будет выполнять операцию на первом порту, чтобы завершить операцию. Например, `MOV 10 ANY` начнёт записывать значение 10 во все порты, но как только оно будет считано с одного порта, оно больше не сможет считываться со всех других портов; операция записи на всех портах будет фактически отменена после успешного завершения одной из них.

`LAST`
Виртуальный порт. Это псевдоцель, которая будет хранить *фактический* порт, который завершил последнюю операцию, которая использовала псевдоцель `ANY`.

## Спецификация языка
В дополнение к списку инструкций код ассемблера, предоставляемый модулю выполнения, может содержать метаданные. Комментарии - это текстовые заметки в коде, которые полностью игнорируются при выполнении программы. Метки отмечают позиции в коде, к которым можно обратиться с помощью инструкций перехода. Комментарии, метки и пустые строки не влияют на адресацию скомпилированной программы. Это актуально при использовании инструкции `JRO`.

### Комментарии
Комментарии обозначаются начинающим `#` (#) знаком решётки. Они могут отображаться и как единственное содержимое строки, так и в той же строке, что и инструкция или метка.  
Пример:  
`# Single line comment`  
`LOOP: # Start of loop`  
`MOV 0, ACC # Reset`

## Определения
Специальная форма комментария может использоваться для создания или удаления "определений", которые являются псевдонимами для некоторых значений. Они облегчают повторное написание используемого кода, перемещая конфигурацию в одно место, где ею можно легко управлять и использовать повторно. Определение создаётся с использованием синтаксиса `#define A B` и удаляется с использованием синтаксиса `#undef A`.
Пример:
`# Let A = RIGHT`
`#define A RIGHT`
`# Move value from right to acc`
`MOV A ACC`
`#undef A`
`MOV A ACC # Error: A is not a valid target`

### Метки
Метки обозначаются строкой, за которой следует `:` (:) двоеточие. Метка всегда относится к инструкции, следующей за ней. При использовании в качестве цели инструкции перехода, счётчик программы должен непосредственно перепрыгнуть на эту метку. Это также означает, что в отношении выполнения программы не имеет значения, находится ли метка на той же строке или на строке, предшествующей инструкции, на которую она ссылается.    
Пример:  
`START: MOV 8, ACC`  
`LOOP:`  
`SUB 1`  
`JGZ LOOP`  
`JMP START`  
`# Never reached`

### Инструкции
`NOP`
Псевдоинструкция, которая не влияет на состояние портов или регистриров модуля выполнения, т.е. не влияет на состояние. `NOP` автоматически компилируется в `ADD NIL`.

#### Передача данных
`MOV <SRC> <DST>`
Передаёт данные из цели `SRC` в цель `DST`. Список допустимых целей см. выше. Обратите внимание, что работа с регистрами / внутренним состоянием обычно выполняется быстрее, чем с портами. Точные сроки не являются частью спецификации и зависят от производителя.  
Пример:  
`MOV 8, ACC` Записывает значение 8 в регистр `ACC`.  
`MOV LEFT, RIGHT` Считывает значение из левого порта, затем записывает считанное значение в правый порт.  
`MOV DOWN, NIL` Считывает значение из нижнего порта и записывает его в `NIL`, фактически удаляя его.

`SWP`
Меняет текущие значения регистров `ACC` и `BAK`.

`SAV`
Копирует текущее значение `ACC` в `BAK`.

#### Арифметические операции
`ADD <SRC>`
Считывает значение из указанной цели `SRC` и добавляет его к текущему значению `ACC`, а затем записывает результат операции обратно в `ACC`. Обратите внимание, что арифметические переполнения автоматически фиксируются, то есть переполнения нет. Значение будет просто будет равно краю диапазона допустимых значений.  
Пример:  
`ADD 1` Добавляет единицу к текущему значению `ACC`.  
`ADD LEFT` Читает значение из левого порта, а затем добавляет его к `ACC`.

`SUB <SRC>`
Считывает значение из указанной цели `SRC` и вычитает его из текущего значения `ACC`, а затем записывает результат операции обратно в `ACC`. Обратите внимание, что арифметические переполнения автоматически фиксируются, то есть переполнения нет. Значение будет просто будет равно краю диапазона допустимых значений.    
Example:  
`SUB 1` Вычитает единицу из текущего значения `ACC`.  
`SUB LEFT` Считывает значение из левого порта, а затем вычитает его из `ACC`.

`MUL <SRC>`
Считывает значение из указанной цели `SRC` и умножает его на текущее значение `ACC`, а затем записывает результат операции обратно в `ACC`. Обратите внимание, что арифметические переполнения автоматически фиксируются, то есть переполнения нет. Значение будет просто будет равно краю диапазона допустимых значений.    
Example:  
`MUL 2` Умножает значение `ACC` на два.  
`MUL LEFT` Считывает значение из левого порта, а затем умножает его на `ACC`.

`DIV <SRC>`
Считывает значение из указанной цели `SRC` и делит на него текущее значение `ACC`, а затем записывает результат операции обратно в `ACC`. Обратите внимание, что деление на ноль приведёт к тому, что система войдет в состояние ошибки и сбросит себя.  
Пример:  
`DIV 2` Делит значение `ACC` на два.  
`DIV LEFT` Считывает значение из левого порта, а затем делит на него `ACC`.

`NEG`
Заменяет текущее значение `ACC` арифметически противоположным и сохраняет результат в `ACC`.

### Битовые операции
`AND <SRC>`
Считывает значение из указанной цели `SRC` и выполняет над ним и текущим значением `ACC` побитовую логическую операцию *и*.
Пример:  
`AND 0x00FF` Обнуляет старший байт значения, хранящегося в `ACC`, оставляя младший байт как есть.
`AND LEFT` Считывает значение из левого порта, а затем использует его как битовую маску для текущего значения в `ACC`. 

`OR <SRC>`
Считывает значение из указанной цели `SRC` и выполняет над ним и текущим значением `ACC` побитовую логическую операцию *или*.
Пример:  
`OR 0x0001` Устанавливает младший бит значения, хранящегося в `ACC`, и записывает результат обратно в `ACC`.
`OR LEFT` Считывает значение из левого порта, затем устанавливает все биты считанного значения, ещё не установленного в `ACC`, и записывает результат обратно в `ACC`.

`XOR <SRC>`
Считывает значение из указанной цели `SRC` и выполняет над ним и текущим значением `ACC` побитовую логическую операцию *исключающее или*.
Пример:  
`XOR 1` Устанавливает младший бит в `ACC`, если он в данный момент не установлен, сбрасывает его, если он установлен.  
`XOR LEFT` Считывает значение из левого порта и применяет к нему и значению `ACC` операцию *исключающее или*.

`SHL <SRC>`
Считывает значение из указанной цели `SRC` и выполняет битовый сдвиг влево текущего значения `ACC` на количество битов, указанных считываемым значением, затем записывает результат операции обратно в `ACC`.
Пример:  
`SHL 4` Сдвигает значение `ACC` влево на четыре бита, например `0x0F` становится `0xF0`.  
`SHL LEFT` Считывает значение из левого порта и сдвигает значение `ACC` влево на это количество битов.

`SHR <SRC>`
Считывает значение из указанной цели `SRC` и выполняет битовый сдвиг вправо текущего значения `ACC` на количество битов, указанных считываемым значением, затем записывает результат операции обратно в `ACC`.
Пример:  
`SHR 4` Сдвигает значение `ACC` вправо на четыре бита, например `0xF0` становится `0x0F`.  
`SHR LEFT` Считывает значение из левого порта и сдвигает значение `ACC` вправо на это количество битов.

`NOT`
Выполняет побитовое отрицание текущего значения `ACC`, затем записывает результат операции обратно в `ACC`.
Пример:  
`NOT` с `ACC`, содержащим значение `0xFF00`, преобразует его в `0x00FF`.

### Манипулирование `LAST`
`RRLAST`
Если текущее значение `LAST` не равно `NIL`, поворачивает значение вправо (по часовой стрелке) на единицу. В противном случае ничего не делает.

`RLLAST`
Если текущее значение `LAST` не равно `NIL`, поворачивает значение влево (по часовой стрелке) на единицу. В противном случае ничего не делает.

### Контроль потока
`JMP <LABEL>`
Безусловно переходит к инструкции, на которую ссылается указанная метка `LABEL`.

`JEZ <LABEL>`
Если текущее значение `ACC` равно нулю (0), переходит к инструкции, на которую ссылается указанная метка `LABEL`. В противном случае продолжает выполнение следующей операции в программе.

`JNZ <LABEL>`
Если текущее значение `ACC` *не* равно нулю (0), переходит к инструкции, на которую ссылается указанная метка `LABEL`. В противном случае продолжает выполнение следующей операции в программе.

`JGZ <LABEL>`
Если текущее значение `ACC` *больше* нуля (0), переходит к инструкции, на которую ссылается указанная метка `LABEL`. В противном случае продолжает выполнение следующей операции в программе.

`JLZ <LABEL>`
Если текущее значение `ACC` *меньше* нуля (0), переходит к инструкции, на которую ссылается указанная метка `LABEL`. В противном случае продолжает выполнение следующей операции в программе.

`JRO <SRC>`
Безусловно переходит на относительный адрес, считанный из указанной цели `SRC`. Это изменяет счётчик программы, добавляя к нему значение, считанное из `SRC`. Выполнение возобновляется по новому адресу. `JRO 0` фактически останавливает модуль выполнения на неопределённый срок.